/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.registration.response;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.connect.registration.response.TrialErrorResponse;
import org.nuxeo.connect.registration.response.TrialRegistrationResponse;
import org.nuxeo.connect.registration.response.TrialSuccessResponse;

public class TestResponses {
    protected String SAMPLE_ERROR = "{\"message\":\"There were some errors in your form:\",\"value\":[{\"message\":\"You must accept the Nuxeo Trial Terms and Conditions\",\"field\":\"termsAndConditions\"}],\"type\":\"error\"}";
    protected String SAMPLE_ERROR_VALUELESS = "{\"message\":\"A server error occurred and we can not currently process your request, but your request has been logged and an Administrator will handle it.\",\"type\":\"error\"}";
    protected String SAMPLE_MESSAGE = "{\"type\":\"message\",\"message\":\"Registration complete.\",\"value\":{\"username\":\"test@toto.com\",\"email\":\"test@toto.com\",\"company\":\"blalba\",\"wizardToken\":\"cmVnaXN0cmF0aW9uT0s6dHJ1ZQpDTElEOjJiMmFiZjUwLTU3ZjEtNGQ1OS1iMGY2LTRiMmRhMmUxMzBhOS0tYTczZjMzZTctM2NmZC00N2YxLWIzMjktOGIxNWIzOTkxNDI1Cg==\"}}";

    @Test
    public void testResponseRead() throws IOException {
        TrialRegistrationResponse res = TrialRegistrationResponse.read((String)this.SAMPLE_ERROR);
        Assert.assertTrue((boolean)(res instanceof TrialErrorResponse));
        Assert.assertEquals((Object)"error", (Object)res.getType());
        Assert.assertTrue((boolean)res.getMessage().startsWith("There were some errors in "));
        res = TrialRegistrationResponse.read((String)this.SAMPLE_ERROR_VALUELESS);
        Assert.assertTrue((boolean)(res instanceof TrialErrorResponse));
        res = TrialRegistrationResponse.read((String)this.SAMPLE_MESSAGE);
        Assert.assertTrue((boolean)(res instanceof TrialSuccessResponse));
    }

    @Test
    public void testErrorParseValue() throws IOException {
        TrialErrorResponse err = (TrialErrorResponse)TrialRegistrationResponse.read((String)this.SAMPLE_ERROR);
        Assert.assertEquals((long)1L, (long)err.getErrors().size());
        TrialErrorResponse.Error error = (TrialErrorResponse.Error)err.getErrors().get(0);
        Assert.assertTrue((boolean)error.getMessage().startsWith("You must accept the"));
        Assert.assertEquals((Object)"termsAndConditions", (Object)error.getField());
    }

    @Test
    public void testErrorMessageLessParseValue() throws IOException {
        TrialErrorResponse err = (TrialErrorResponse)TrialRegistrationResponse.read((String)this.SAMPLE_ERROR_VALUELESS);
        Assert.assertEquals((long)0L, (long)err.getErrors().size());
    }

    @Test
    public void testSucessParseValue() throws IOException {
        TrialSuccessResponse res = (TrialSuccessResponse)TrialRegistrationResponse.read((String)this.SAMPLE_MESSAGE);
        Assert.assertEquals((Object)"test@toto.com", (Object)res.getEmail());
        Assert.assertEquals((Object)"blalba", (Object)res.getCompany());
        Assert.assertEquals((long)2L, (long)res.getToken().keySet().size());
        Assert.assertTrue((boolean)res.getToken().containsKey("CLID"));
        Assert.assertTrue((boolean)res.getToken().containsKey("registrationOK"));
    }
}

