/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageState;

public class TestUninstallCheck
extends AbstractPackageManagerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestUninstallCheck.getDownloads("localuninstall.json");
        TestUninstallCheck.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "localuninstall"), true);
    }

    public void testUninstallDependencies() throws Exception {
        DownloadablePackage pkg = this.pm.getPackage("A-1.0.0");
        TestUninstallCheck.assertNotNull((Object)pkg);
        List<DownloadablePackage> pkgToRemove = this.performUninstall(pkg);
        log.info(pkgToRemove);
        TestUninstallCheck.assertFalse((boolean)pkgToRemove.contains(pkg));
        TestUninstallCheck.assertTrue((boolean)pkgToRemove.contains(this.pm.getPackage("B-1.0.0")));
        TestUninstallCheck.assertTrue((boolean)pkgToRemove.contains(this.pm.getPackage("C-1.0.0")));
        TestUninstallCheck.assertTrue((boolean)pkgToRemove.contains(this.pm.getPackage("D-1.0.0")));
        TestUninstallCheck.assertTrue((boolean)pkgToRemove.contains(this.pm.getPackage("E-1.0.0")));
        TestUninstallCheck.assertFalse((boolean)pkgToRemove.contains(this.pm.getPackage("F-1.0.0")));
        TestUninstallCheck.assertFalse((boolean)pkgToRemove.contains(this.pm.getPackage("G-1.0.0")));
        TestUninstallCheck.assertTrue((this.pm.getPackage("H-1.0.0").getPackageState() != PackageState.INSTALLED || pkgToRemove.contains(this.pm.getPackage("H-1.0.0")) ? 1 : 0) != 0);
    }

    protected List<DownloadablePackage> performUninstall(DownloadablePackage pkg) {
        return this.pm.getUninstallDependencies((Package)pkg, null);
    }
}

