/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.Arrays;
import java.util.List;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.CUDFHelper;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;
import org.nuxeo.connect.update.Version;

public class TestPackageDependencyResolutionP2CUDF
extends AbstractPackageManagerTestCase {
    protected DependencyResolution depResolution;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestPackageDependencyResolutionP2CUDF.getDownloads("localdep1.json", true);
        List<DownloadablePackage> remote = TestPackageDependencyResolutionP2CUDF.getDownloads("remotedep1.json");
        TestPackageDependencyResolutionP2CUDF.assertNotNull(local);
        TestPackageDependencyResolutionP2CUDF.assertTrue((local.size() > 0 ? 1 : 0) != 0);
        TestPackageDependencyResolutionP2CUDF.assertNotNull(remote);
        TestPackageDependencyResolutionP2CUDF.assertTrue((remote.size() > 0 ? 1 : 0) != 0);
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "localDummy"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remoteDummy"), false);
        CUDFHelper.defaultAllowSNAPSHOT = true;
    }

    protected void tearDown() throws Exception {
        CUDFHelper.defaultAllowSNAPSHOT = false;
    }

    public void testSimpleDeps() throws Exception {
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("C-1.0.0"), null, null, null);
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)8, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)5, (int)this.depResolution.getNewPackagesToDownload().size());
    }

    public void testSimpleUpgrade() throws Exception {
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("E-1.0.0"), null, null, null);
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)1, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)7, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)4, (int)this.depResolution.getNewPackagesToDownload().size());
    }

    public void testDoubleDownload() throws Exception {
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("F-1.0.0"), null, null, null);
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)1, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)7, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)7, (int)this.depResolution.getNewPackagesToDownload().size());
    }

    public void test3LevelsDeps() throws Exception {
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("O-1.0.0"), null, null, null);
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)8, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)7, (int)this.depResolution.getNewPackagesToDownload().size());
    }

    public void testStudioDeps() throws Exception {
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("NXBT-872"), null, null, "6.0");
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)1, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)8, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)2, (int)this.depResolution.getNewPackagesToDownload().size());
    }

    public void testDoubleUpgrade() throws Exception {
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("CC-1.0.0"), null, null, null);
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)2, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)6, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)5, (int)this.depResolution.getNewPackagesToDownload().size());
    }

    public void testForceRemove() throws Exception {
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("X1-1.0.0"), null, null, null);
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)8, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)4, (int)this.depResolution.getNewPackagesToDownload().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToRemove().size());
    }

    public void testForceUpgradeOverRemove() throws Exception {
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("X2-1.0.0"), null, null, null);
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)8, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)4, (int)this.depResolution.getNewPackagesToDownload().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToRemove().size());
    }

    public void testPlatformFiltering() throws Exception {
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("PF1-1.0.0"), null, null, null);
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)8, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)4, (int)this.depResolution.getNewPackagesToDownload().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToRemove().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((Object)new Version("2.0.0"), this.depResolution.getNewPackagesToDownload().get("PF2"));
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("PF1-1.0.0"), null, null, "5.3.1");
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)8, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)4, (int)this.depResolution.getNewPackagesToDownload().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToRemove().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((Object)new Version("2.0.0"), this.depResolution.getNewPackagesToDownload().get("PF2"));
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("PF1-1.0.0"), null, null, "5.3.0");
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isValidated());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToInstall().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToUpgrade().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)8, (int)this.depResolution.getLocalUnchangedPackages().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)4, (int)this.depResolution.getNewPackagesToDownload().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((int)0, (int)this.depResolution.getLocalPackagesToRemove().size());
        TestPackageDependencyResolutionP2CUDF.assertEquals((Object)new Version("1.0.0"), this.depResolution.getNewPackagesToDownload().get("PF2"));
        this.depResolution = this.pm.resolveDependencies(Arrays.asList("PF1-1.0.0"), null, null, "5.3.2");
        log.info((Object)this.depResolution.toString());
        TestPackageDependencyResolutionP2CUDF.assertTrue((boolean)this.depResolution.isFailed());
    }
}

