/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class TestOptionalDependencies
extends AbstractPackageManagerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestOptionalDependencies.getDownloads("local8.json");
        TestOptionalDependencies.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "local8"), true);
    }

    public void testOptionalDependencyIsNotRequired() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("test-opt-dep1-1.0.0"), null, null, null);
        log.info((Object)depResolution.toString());
        TestOptionalDependencies.assertTrue((boolean)depResolution.isValidated());
        TestOptionalDependencies.assertEquals((int)1, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestOptionalDependencies.assertEquals((String)"test-opt-dep1-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
        depResolution = this.pm.resolveDependencies(Arrays.asList("test-opt-dep4-1.0.0"), null, null, null);
        log.info((Object)depResolution.toString());
        TestOptionalDependencies.assertTrue((boolean)depResolution.isValidated());
        TestOptionalDependencies.assertEquals((int)1, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestOptionalDependencies.assertEquals((String)"test-opt-dep4-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
    }

    public void testOptionalDependencyIsOrderedFirst() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("test-opt-dep2", "test-opt-dep1", "zz-nuxeo-jsf-ui", "zz-nuxeo-web-ui-1.0.2"), null, null, null);
        log.info((Object)depResolution.toString());
        TestOptionalDependencies.assertTrue((boolean)depResolution.isValidated());
        TestOptionalDependencies.assertEquals((int)4, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestOptionalDependencies.assertEquals((String)"zz-nuxeo-web-ui-1.0.2", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
        TestOptionalDependencies.assertEquals((String)"zz-nuxeo-jsf-ui-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(1)));
        TestOptionalDependencies.assertEquals((String)"test-opt-dep1-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(2)));
        TestOptionalDependencies.assertEquals((String)"test-opt-dep2-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(3)));
    }

    public void testTransitiveOptionalDependencyIsOrderedFirst() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("aa-test-trans-dep1", "test-opt-dep1"), null, null, null);
        log.info((Object)depResolution.toString());
        TestOptionalDependencies.assertTrue((boolean)depResolution.isValidated());
        TestOptionalDependencies.assertEquals((int)2, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestOptionalDependencies.assertEquals((String)"test-opt-dep1-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
        TestOptionalDependencies.assertEquals((String)"aa-test-trans-dep1-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(1)));
        depResolution = this.pm.resolveDependencies(Arrays.asList("aa-test-trans-dep2", "zz-nuxeo-jsf-ui"), null, null, null);
        log.info((Object)depResolution.toString());
        TestOptionalDependencies.assertTrue((boolean)depResolution.isValidated());
        TestOptionalDependencies.assertEquals((int)3, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestOptionalDependencies.assertEquals((String)"zz-nuxeo-jsf-ui-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
        TestOptionalDependencies.assertEquals((String)"test-opt-dep2-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(1)));
        TestOptionalDependencies.assertEquals((String)"aa-test-trans-dep2-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(2)));
    }

    public void testReinstallForLatelyResolvedOptionalDependency() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("test-opt-dep6-1.0.0"), null, null, null);
        log.info((Object)depResolution.toString());
        TestOptionalDependencies.assertTrue((boolean)depResolution.isValidated());
        TestOptionalDependencies.assertEquals((int)3, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestOptionalDependencies.assertEquals((String)"test-opt-dep3-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
        TestOptionalDependencies.assertEquals((String)"zz-nuxeo-web-ui-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(1)));
        TestOptionalDependencies.assertEquals((String)"test-opt-dep6-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(2)));
        TestOptionalDependencies.assertEquals((int)1, (int)depResolution.getOrderedPackageIdsToRemove().size());
        TestOptionalDependencies.assertEquals((String)"zz-nuxeo-web-ui-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToRemove().get(0)));
    }

    public void testReinstallForLatelyUnresolvedOptionalDependency() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(null, Arrays.asList("test-opt-dep5-1.0.0"), null, null);
        log.info((Object)depResolution.toString());
        TestOptionalDependencies.assertTrue((boolean)depResolution.isValidated());
        TestOptionalDependencies.assertEquals((int)1, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestOptionalDependencies.assertEquals((String)"zz-nuxeo-web-ui-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
        TestOptionalDependencies.assertEquals((int)2, (int)depResolution.getOrderedPackageIdsToRemove().size());
        TestOptionalDependencies.assertEquals((String)"zz-nuxeo-web-ui-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToRemove().get(0)));
        TestOptionalDependencies.assertEquals((String)"test-opt-dep5-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToRemove().get(1)));
    }

    public void testNoReinstallForPackageBeingRemoved() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(null, Arrays.asList("test-opt-dep5-1.0.0", "zz-nuxeo-web-ui-1.0.0"), null, null);
        log.info((Object)depResolution.toString());
        TestOptionalDependencies.assertTrue((boolean)depResolution.isValidated());
        TestOptionalDependencies.assertEquals((int)0, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestOptionalDependencies.assertEquals((int)2, (int)depResolution.getOrderedPackageIdsToRemove().size());
        TestOptionalDependencies.assertEquals((String)"zz-nuxeo-web-ui-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToRemove().get(0)));
        TestOptionalDependencies.assertEquals((String)"test-opt-dep5-1.0.0", (String)((String)depResolution.getOrderedPackageIdsToRemove().get(1)));
    }

    public void testNoReinstallForUpgradingOptionalDependency() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("test-opt-dep5-1.0.1"), null, null, null);
        log.info((Object)depResolution.toString());
        TestOptionalDependencies.assertTrue((boolean)depResolution.isValidated());
        TestOptionalDependencies.assertEquals((int)1, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestOptionalDependencies.assertEquals((String)"test-opt-dep5-1.0.1", (String)((String)depResolution.getOrderedPackageIdsToInstall().get(0)));
        TestOptionalDependencies.assertEquals((int)0, (int)depResolution.getOrderedPackageIdsToRemove().size());
    }
}

