/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class TestNoKeep
extends AbstractPackageManagerTestCase {
    public void testInstallB() throws Exception {
        List<DownloadablePackage> local = TestNoKeep.getDownloads("localNoKeep1.json");
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "localNoKeep1"), true);
        ArrayList<String> pkgToSet = new ArrayList<String>();
        pkgToSet.add("B");
        DependencyResolution depResolution = this.pm.resolveDependencies(pkgToSet, null, null, null, false, false);
        log.info((Object)depResolution.toString());
        TestNoKeep.assertTrue((boolean)depResolution.isValidated());
        TestNoKeep.assertEquals((int)2, (int)depResolution.getLocalPackagesToInstall().size());
        TestNoKeep.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestNoKeep.assertEquals((int)0, (int)depResolution.getLocalUnchangedPackages().size());
        TestNoKeep.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        TestNoKeep.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
    }

    public void testInstallBD() throws Exception {
        List<DownloadablePackage> local = TestNoKeep.getDownloads("localNoKeep2.json");
        List<DownloadablePackage> remote = TestNoKeep.getDownloads("remoteNoKeep2.json");
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "localNoKeep2"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remoteNoKeep2"), true);
        ArrayList<String> pkgToSet = new ArrayList<String>();
        pkgToSet.add("B");
        pkgToSet.add("D");
        DependencyResolution depResolution = this.pm.resolveDependencies(pkgToSet, null, null, null, false, false);
        log.info((Object)depResolution.toString());
        TestNoKeep.assertTrue((boolean)depResolution.isValidated());
        TestNoKeep.assertEquals((int)0, (int)depResolution.getLocalPackagesToInstall().size());
        TestNoKeep.assertEquals((int)0, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestNoKeep.assertEquals((int)2, (int)depResolution.getLocalUnchangedPackages().size());
        TestNoKeep.assertEquals((int)1, (int)depResolution.getNewPackagesToDownload().size());
        TestNoKeep.assertEquals((int)1, (int)depResolution.getLocalPackagesToRemove().size());
    }

    public void testInstallAB() throws Exception {
        List<DownloadablePackage> local = TestNoKeep.getDownloads("localNoKeep3.json");
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "localNoKeep3"), true);
        ArrayList<String> pkgToSet = new ArrayList<String>();
        pkgToSet.add("B");
        DependencyResolution depResolution = this.pm.resolveDependencies(pkgToSet, null, null, null, false, false);
        log.info((Object)depResolution.toString());
        TestNoKeep.assertTrue((boolean)depResolution.isValidated());
        TestNoKeep.assertEquals((int)2, (int)depResolution.getLocalPackagesToInstall().size());
        TestNoKeep.assertEquals((int)2, (int)depResolution.getLocalPackagesToUpgrade().size());
        TestNoKeep.assertEquals((int)0, (int)depResolution.getLocalUnchangedPackages().size());
        TestNoKeep.assertEquals((int)0, (int)depResolution.getNewPackagesToDownload().size());
        TestNoKeep.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
    }
}

