/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class TestHotFixes
extends AbstractPackageManagerTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestHotFixes.getDownloads("localhf2.json");
        List<DownloadablePackage> remote = TestHotFixes.getDownloads("remotehf2.json");
        TestHotFixes.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        TestHotFixes.assertTrue((boolean)CollectionUtils.isNotEmpty(remote));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "localhf2"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remotehf2"), false);
    }

    public void testListLastHotfixes() {
        List<String> expectedLastHotfixes = Arrays.asList("hf00-1.0.0", "hf01-1.0.1", "hf01PATCH-1.0.0", "hf02-1.0.0", "hf03-1.0.0", "hf04-1.0.0", "hf05-1.0.0", "hf06-1.0.0", "hf07-1.0.0", "hf08-1.0.0", "hf09-1.11.0", "hf10-1.0.0", "hf11-1.0.0");
        List lastHotfixes = this.pm.listLastHotfixes(null, false);
        TestHotFixes.assertEquals((int)expectedLastHotfixes.size(), (int)lastHotfixes.size());
        lastHotfixes.forEach(hfName -> TestHotFixes.assertTrue((String)(hfName + " should not be listed"), (boolean)expectedLastHotfixes.contains(hfName)));
        List<String> expectedLastSnapshotHotfixes = Arrays.asList("hf00-1.0.0", "hf01-1.0.2-SNAPSHOT", "hf01PATCH-1.0.0", "hf02-1.0.0", "hf03-1.0.0", "hf04-1.0.2-SNAPSHOT", "hf05-1.0.0", "hf06-1.0.0", "hf07-1.0.0", "hf08-1.0.0", "hf09-1.11.0", "hf10-1.0.0", "hf11-1.0.0");
        lastHotfixes = this.pm.listLastHotfixes(null, true);
        TestHotFixes.assertEquals((int)expectedLastSnapshotHotfixes.size(), (int)lastHotfixes.size());
        lastHotfixes.forEach(hfName -> TestHotFixes.assertTrue((String)(hfName + " should not be listed"), (boolean)expectedLastSnapshotHotfixes.contains(hfName)));
    }

    public void testResolutionOrder() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(this.pm.listLastHotfixes(null, false), null, null, null);
        log.info((Object)depResolution.toString());
        TestHotFixes.assertTrue((boolean)depResolution.isValidated());
        String expectedOrder = "hf01-1.0.1/hf01PATCH-1.0.0/hf02-1.0.0/hf03-1.0.0/hf04-1.0.0/hf05-1.0.0/hf06-1.0.0/hf07-1.0.0/hf08-1.0.0/hf09-1.11.0/hf10-1.0.0/hf11-1.0.0";
        TestHotFixes.assertEquals((String)"Bad dependencies order", (String)expectedOrder, (String)depResolution.getInstallationOrderAsString());
        depResolution = this.pm.resolveDependencies(this.pm.listLastHotfixes(null, true), null, null, null);
        log.info((Object)depResolution.toString());
        TestHotFixes.assertTrue((boolean)depResolution.isValidated());
        expectedOrder = "hf01-1.0.2-SNAPSHOT/hf01PATCH-1.0.0/hf02-1.0.0/hf03-1.0.0/hf04-1.0.2-SNAPSHOT/hf05-1.0.0/hf06-1.0.0/hf07-1.0.0/hf08-1.0.0/hf09-1.11.0/hf10-1.0.0/hf11-1.0.0";
        TestHotFixes.assertEquals((String)"Bad dependencies order", (String)expectedOrder, (String)depResolution.getInstallationOrderAsString());
    }
}

