/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.pm.tests;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class TestConflicts
extends AbstractPackageManagerTestCase {
    protected DummyPackageSource remoteSource;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = TestConflicts.getDownloads("localConflict.json");
        List<DownloadablePackage> remote = TestConflicts.getDownloads("remoteConflict.json");
        TestConflicts.assertTrue((boolean)CollectionUtils.isNotEmpty(local));
        TestConflicts.assertTrue((boolean)CollectionUtils.isNotEmpty(remote));
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "localConflict"), true);
        this.remoteSource = new DummyPackageSource(remote, "remoteConflict");
        this.pm.registerSource((PackageSource)this.remoteSource, false);
    }

    public void testUninstallOnConflict() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("nuxeo-jsf-ui-9.10.0"), null, null, null);
        log.info((Object)depResolution.toString());
        TestConflicts.assertTrue((boolean)depResolution.isValidated());
        TestConflicts.assertEquals((int)1, (int)depResolution.getLocalPackagesToRemove().size());
        TestConflicts.assertTrue((boolean)depResolution.getLocalPackagesToRemove().containsKey("nuxeo-9.10-HF01"));
        TestConflicts.assertEquals((int)1, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestConflicts.assertTrue((boolean)depResolution.getOrderedPackageIdsToInstall().contains("nuxeo-jsf-ui-9.10.0"));
    }

    public void testInstallWithoutConflict() throws Exception {
        DependencyResolution depResolution = this.pm.resolveDependencies(Arrays.asList("nuxeo-jsf-ui"), null, null, null);
        log.info((Object)depResolution.toString());
        TestConflicts.assertTrue((boolean)depResolution.isValidated());
        TestConflicts.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        TestConflicts.assertEquals((int)1, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestConflicts.assertTrue((boolean)depResolution.getOrderedPackageIdsToInstall().contains("nuxeo-jsf-ui-9.10.0-HF01"));
        this.remoteSource.reset(TestConflicts.getDownloads("remoteConflict2.json"));
        depResolution = this.pm.resolveDependencies(Arrays.asList("nuxeo-jsf-ui-9.10.0-HF01"), null, null, null);
        log.info((Object)depResolution.toString());
        TestConflicts.assertTrue((boolean)depResolution.isValidated());
        TestConflicts.assertEquals((int)0, (int)depResolution.getLocalPackagesToRemove().size());
        TestConflicts.assertEquals((int)1, (int)depResolution.getOrderedPackageIdsToInstall().size());
        TestConflicts.assertTrue((boolean)depResolution.getOrderedPackageIdsToInstall().contains("nuxeo-jsf-ui-9.10.0-HF01"));
    }
}

