/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages.dependencies;

import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.pm.tests.AbstractPackageManagerTestCase;
import org.nuxeo.connect.pm.tests.DummyPackageSource;

public class P2CUDFDependencyResolverTest
extends AbstractPackageManagerTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        List<DownloadablePackage> local = P2CUDFDependencyResolverTest.getDownloads("local3.json");
        List<DownloadablePackage> remote = P2CUDFDependencyResolverTest.getDownloads("remote3.json");
        this.pm.registerSource((PackageSource)new DummyPackageSource(local, "local3"), true);
        this.pm.registerSource((PackageSource)new DummyPackageSource(remote, "remote3"), false);
    }

    @Test
    public void testResolve() throws Exception {
        DependencyResolution resolution = this.pm.resolveDependencies(Arrays.asList("nuxeo-dm-5.5.0"), null, null, "5.5.0");
        P2CUDFDependencyResolverTest.assertFalse((String)resolution.toString(), (boolean)resolution.isFailed());
        P2CUDFDependencyResolverTest.assertEquals((int)2, (int)resolution.getRemovePackageIds().size());
        P2CUDFDependencyResolverTest.assertEquals(Arrays.asList("nuxeo-cmf-5.5.0", "nuxeo-content-browser-1.1.0-cmf"), (Object)resolution.getRemovePackageIds());
        P2CUDFDependencyResolverTest.assertEquals((int)2, (int)resolution.getOrderedPackageIdsToInstall().size());
        P2CUDFDependencyResolverTest.assertEquals(Arrays.asList("nuxeo-content-browser-1.1.0", "nuxeo-dm-5.5.0"), (Object)resolution.getOrderedPackageIdsToInstall());
    }
}

