/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ListAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectClientVersionMismatchError;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.http.ConnectHttpConnector;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.SubscriptionStatus;
import org.nuxeo.connect.update.PackageType;

public class TestConnectHttpConnector {
    private final String testTargetPlatform = "server-10.3";
    private ConnectHttpConnector httpConnector;
    private MockWebServer mockServer;

    @Before
    public void setUp() throws Exception {
        this.mockServer = new MockWebServer();
        this.httpConnector = new ConnectHttpConnector();
        this.httpConnector.overrideUrl = this.mockServer.url("/").toString();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.httpConnector.flushCache();
            for (DownloadingPackage downloadingPackage : NuxeoConnectClient.getDownloadManager().listDownloadingPackages()) {
                NuxeoConnectClient.getDownloadManager().removeDownloadingPackage(downloadingPackage.getId());
            }
        }
        finally {
            this.mockServer.shutdown();
        }
    }

    @Test
    public void it_should_handle_OK_response_for_connect_status() throws ConnectServerError, InterruptedException {
        this.mockServer.enqueue(this.buildDefaultResponse());
        SubscriptionStatus connectStatus = this.httpConnector.getConnectStatus();
        Assertions.assertThat((Object)connectStatus).isNotNull();
        TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "status");
    }

    @Test
    public void it_should_handle_OK_response_for_get_downloads() throws ConnectServerError, InterruptedException {
        this.mockServer.enqueue(this.buildDefaultResponse().setBody("[{\"name\" : \"test1\"}, {\"name\" : \"test2\"}]"));
        String typeStr = String.valueOf(PackageType.ADDON);
        List downloads = this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
        ((ListAssert)Assertions.assertThat((List)downloads).isNotNull()).hasSize(2);
        TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownloads/" + typeStr + "?targetPlatform=" + "server-10.3");
    }

    @Test
    public void it_should_handle_OK_response_for_get_download() throws ConnectServerError, InterruptedException {
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        String payload = String.format("{\"name\" : \"%s\", \"version\" : \"%s\"}", pkgName, pkgVersion);
        this.mockServer.enqueue(this.buildDefaultResponse().setBody(payload));
        DownloadingPackage download = this.httpConnector.getDownload(pkgId);
        TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownload/" + pkgId);
        Assertions.assertThat((Object)download).isNotNull();
    }

    @Test
    public void it_should_handle_NOT_FOUND_response_for_connect_status() throws ConnectServerError {
        MockResponse response = this.buildDefaultResponse().setResponseCode(404);
        this.mockServer.enqueue(response);
        SubscriptionStatus connectStatus = this.httpConnector.getConnectStatus();
        Assertions.assertThat((Object)connectStatus).isNotNull();
    }

    @Test
    public void it_should_handle_NOT_FOUND_response_for_get_downloads() throws ConnectServerError, InterruptedException {
        String typeStr = String.valueOf(PackageType.ADDON);
        MockResponse response = this.buildDefaultResponse().setBody("[{\"name\" : \"test1\"}, {\"name\" : \"test2\"}]").setResponseCode(404);
        this.mockServer.enqueue(response);
        List downloads = this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
        ((ListAssert)Assertions.assertThat((List)downloads).isNotNull()).hasSize(2);
        TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownloads/" + typeStr + "?targetPlatform=" + "server-10.3");
    }

    @Test
    public void it_should_handle_NOT_FOUND_response_for_get_download() throws ConnectServerError {
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        MockResponse response = this.buildDefaultResponse().setBody("{\"name\" : \"" + pkgName + "\", \"version\" : \"" + pkgVersion + "\"}").setResponseCode(404);
        this.mockServer.enqueue(response);
        DownloadingPackage download = this.httpConnector.getDownload(pkgId);
        Assertions.assertThat((Object)download).isNotNull();
    }

    @Test
    public void it_should_handle_NO_CONTENT_response_for_connect_status() throws InterruptedException {
        MockResponse response = this.buildDefaultResponse().setResponseCode(204);
        this.mockServer.enqueue(response);
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "status");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"null response from server");
        }
    }

    @Test
    public void it_should_handle_NO_CONTENT_response_for_get_downloads() throws ConnectServerError, InterruptedException {
        this.mockServer.enqueue(this.buildDefaultResponse().setResponseCode(204));
        String typeStr = String.valueOf(PackageType.ADDON);
        List downloads = this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
        ((ListAssert)Assertions.assertThat((List)downloads).isNotNull()).hasSize(0);
        TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownloads/" + typeStr + "?targetPlatform=" + "server-10.3");
    }

    @Test
    public void it_should_handle_NO_CONTENT_response_for_get_download() throws ConnectServerError, InterruptedException {
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.mockServer.enqueue(this.buildDefaultResponse().setResponseCode(204));
        DownloadingPackage download = this.httpConnector.getDownload(pkgId);
        Assertions.assertThat((Object)download).isNull();
        TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownload/" + pkgId);
    }

    @Test
    public void it_should_handle_UNAUTHORIZED_response() throws InterruptedException {
        MockResponse response = this.buildDefaultResponse().setResponseCode(401);
        this.mockServer.enqueue(response);
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "status");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Connect server refused authentication (returned 401)");
        }
        this.mockServer.enqueue(response);
        try {
            this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            String typeStr = String.valueOf(PackageType.ADDON);
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownloads/" + typeStr + "?targetPlatform=" + "server-10.3");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Connect server refused authentication (returned 401)");
        }
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.mockServer.enqueue(response);
        try {
            this.httpConnector.getDownload(pkgId);
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownload/" + pkgId);
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Connect server refused authentication (returned 401)");
        }
    }

    @Test
    public void it_should_handle_GATEWAY_TIMEOUT_response() throws InterruptedException {
        MockResponse response = new MockResponse().setBody("{}").setResponseCode(504);
        this.mockServer.enqueue(response);
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "status");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 504");
        }
        this.mockServer.enqueue(response);
        try {
            this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            String typeStr = String.valueOf(PackageType.ADDON);
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownloads/" + typeStr + "?targetPlatform=" + "server-10.3");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 504");
        }
        this.mockServer.enqueue(response);
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        try {
            this.httpConnector.getDownload(pkgId);
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownload/" + pkgId);
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 504");
        }
    }

    @Test
    public void it_should_handle_REQUEST_TIMEOUT_response() throws InterruptedException {
        MockResponse response = this.buildDefaultResponse().setResponseCode(408);
        this.mockServer.enqueue(response);
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "status");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 408");
        }
        this.mockServer.enqueue(response);
        String typeStr = String.valueOf(PackageType.ADDON);
        try {
            this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownloads/" + typeStr + "?targetPlatform=" + "server-10.3");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 408");
        }
        this.mockServer.enqueue(response);
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        try {
            this.httpConnector.getDownload(pkgId);
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownload/" + pkgId);
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Timeout 408");
        }
    }

    @Test
    public void it_should_handle_INTERNAL_SERVER_ERROR_response() throws ConnectServerError, InterruptedException {
        MockResponse response = new MockResponse().setBody("{\"errorClass\" : \"ConnectSecurityError\", \"message\" : \"server message\"}").setResponseCode(500);
        this.mockServer.enqueue(response);
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectSecurityError.class);
        }
        catch (ConnectSecurityError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "status");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"server message");
        }
        response = new MockResponse().setBody("{\"errorClass\" : \"ConnectClientVersionMismatchError\", \"message\" : \"server message\"}").setResponseCode(500);
        this.mockServer.enqueue(response);
        String typeStr = String.valueOf(PackageType.ADDON);
        try {
            this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
            Fail.failBecauseExceptionWasNotThrown(ConnectClientVersionMismatchError.class);
        }
        catch (ConnectClientVersionMismatchError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownloads/" + typeStr + "?targetPlatform=" + "server-10.3");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"server message");
        }
        response = new MockResponse().setBody("{\"errorClass\" : \"UnknownError\", \"message\" : \"server message\"}").setResponseCode(500);
        this.mockServer.enqueue(response);
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        try {
            this.httpConnector.getDownload(pkgId);
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "getDownload/" + pkgId);
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"server message");
        }
        response = new MockResponse().setBody("\"{malformed JSON\"").setResponseCode(500);
        this.mockServer.enqueue(response);
        try {
            this.httpConnector.getConnectStatus();
            Fail.failBecauseExceptionWasNotThrown(ConnectServerError.class);
        }
        catch (ConnectServerError e) {
            TestConnectHttpConnector.assertThatPathIsCalled(this.mockServer, "status");
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Server returned a code 500");
        }
    }

    @Test
    public void call_with_set_cookie_with_expires_should_not_raise_a_warning() throws Exception {
        TestAppender appender = new TestAppender();
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        MockResponse response = this.buildDefaultResponse().setHeader("Set-Cookie", (Object)"Path=/;Max-Age=31536000;Secure;Expires=Wed, 17 Jun 2020 16:00:18 GMT;HttpOnly");
        this.mockServer.enqueue(response);
        ConnectHttpConnector httpConnector = new ConnectHttpConnector();
        httpConnector.overrideUrl = this.mockServer.url("/").url().toString();
        SubscriptionStatus status = httpConnector.getConnectStatus();
        Assert.assertNotNull((Object)status);
        List warnings = appender.getLog().stream().filter(l -> l.getLevel().equals((Object)Level.WARN)).collect(Collectors.toList());
        Assert.assertEquals((long)0L, (long)warnings.size());
        logger.removeAppender((Appender)appender);
    }

    @Test
    public void all_call_use_gzip_encoding() throws Exception {
        this.mockServer.enqueue(this.buildDefaultResponse());
        this.httpConnector.getConnectStatus();
        RecordedRequest request = this.mockServer.takeRequest();
        Assertions.assertThat((String)request.getHeader("Accept-Encoding")).contains(new CharSequence[]{"gzip"});
        this.mockServer.enqueue(this.buildDefaultResponse().setBody("[]"));
        this.httpConnector.getDownloads(PackageType.ADDON, "server-10.3");
        request = this.mockServer.takeRequest();
        Assertions.assertThat((String)request.getHeader("Accept-Encoding")).contains(new CharSequence[]{"gzip"});
        String pkgName = "test1";
        String pkgVersion = "1.0.0";
        String pkgId = pkgName + "-" + pkgVersion;
        this.mockServer.enqueue(this.buildDefaultResponse().setBody("{\"name\" : \"" + pkgName + "\", \"version\" : \"" + pkgVersion + "\"}"));
        this.httpConnector.getDownload(pkgId);
        request = this.mockServer.takeRequest();
        Assertions.assertThat((String)request.getHeader("Accept-Encoding")).contains(new CharSequence[]{"gzip"});
    }

    private static void assertThatPathIsCalled(MockWebServer mockServer, String path) throws InterruptedException {
        RecordedRequest request1 = mockServer.takeRequest();
        Assert.assertEquals((Object)("/" + path), (Object)request1.getPath());
    }

    private MockResponse buildDefaultResponse() {
        MockResponse response = new MockResponse().setResponseCode(200).setBody("{}");
        return response;
    }

    class TestAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> log = new ArrayList<LoggingEvent>();

        TestAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent loggingEvent) {
            this.log.add(loggingEvent);
        }

        public void close() {
        }

        public List<LoggingEvent> getLog() {
            return new ArrayList<LoggingEvent>(this.log);
        }
    }
}

