/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http;

import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.connector.http.ConnectHttpConnector;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;

public class ProxyHelperTest {
    private ConnectHttpConnector httpConnector;
    private MockWebServer proxyServer;
    private MockWebServer connectServer;

    @Before
    public void setUp() throws Exception {
        this.proxyServer = new MockWebServer();
        this.connectServer = new MockWebServer();
        ConnectUrlConfig.useProxy = null;
        System.setProperty("nuxeo.http.proxy.host", this.proxyServer.getHostName());
        System.setProperty("nuxeo.http.proxy.port", Integer.toString(this.proxyServer.getPort()));
        this.httpConnector = new ConnectHttpConnector();
        this.httpConnector.overrideUrl = this.connectServer.url("/").toString();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.httpConnector.flushCache();
        }
        finally {
            this.proxyServer.shutdown();
        }
        System.getProperties().remove("nuxeo.http.proxy.host");
        System.getProperties().remove("nuxeo.http.proxy.port");
        ConnectUrlConfig.useProxy = null;
    }

    @Test
    public void it_should_call_only_the_proxy() throws ConnectServerError, InterruptedException {
        this.proxyServer.enqueue(this.buildDefaultResponse());
        this.connectServer.enqueue(this.buildDefaultResponse());
        this.httpConnector.getConnectStatus();
        Assertions.assertThat((int)this.connectServer.getRequestCount()).isEqualTo(0);
        RecordedRequest request = this.proxyServer.takeRequest();
        Assertions.assertThat((Object)request).isNotNull();
    }

    private MockResponse buildDefaultResponse() {
        MockResponse response = new MockResponse().setResponseCode(200).setBody("{}");
        return response;
    }
}

