/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.invalidations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.In;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.web.context.CaseManagementContextHolder;
import org.nuxeo.cm.web.invalidations.CaseManagementContextChecker;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

public abstract class CaseManagementContextBoundInstance
implements CaseManagementContextHolder {
    private static final long serialVersionUID = 3402178528822538781L;
    private static final Log log = LogFactory.getLog(CaseManagementContextBoundInstance.class);
    @In(create=true, required=false)
    protected transient CaseManagementContextHolder cmContextHolder;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected Mailbox cachedMailbox;
    protected Case cachedEnvelope;
    protected DocumentModel cachedEmail;

    @CaseManagementContextChecker
    public void onMailboxContextChange(CaseManagementContextHolder correspContextHolder) throws ClientException {
        if (correspContextHolder == null) {
            log.error((Object)"Cannot check context: instance is null");
            return;
        }
        Mailbox currentMailbox = correspContextHolder.getCurrentMailbox();
        if (this.hasCacheKeyChanged(this.generateMailboxCacheKey(this.cachedMailbox), this.generateMailboxCacheKey(currentMailbox))) {
            this.resetMailboxCache(this.cachedMailbox, currentMailbox);
            this.cachedMailbox = currentMailbox;
        }
        Case currentEnvelope = correspContextHolder.getCurrentCase();
        if (this.hasCacheKeyChanged(this.generateCaseCacheKey(this.cachedEnvelope), this.generateCaseCacheKey(currentEnvelope))) {
            this.resetCaseCache(this.cachedEnvelope, currentEnvelope);
            this.cachedEnvelope = currentEnvelope;
        }
        if (currentEnvelope == null || currentEnvelope.isEmpty()) {
            return;
        }
        DocumentModel currentEmail = correspContextHolder.getCurrentCaseItem();
        if (this.hasCacheKeyChanged(this.generateCurrentCaseItemCacheKey(this.cachedEmail), this.generateCurrentCaseItemCacheKey(currentEmail))) {
            this.resetCurrentCaseItemCache(this.cachedEmail, currentEmail);
            this.cachedEmail = currentEmail;
        }
    }

    protected boolean hasCacheKeyChanged(String cachedKey, String newKey) throws ClientException {
        if (cachedKey == null && newKey != null || cachedKey != null && newKey == null) {
            return true;
        }
        if (cachedKey == null && newKey == null) {
            return false;
        }
        return !cachedKey.equals(newKey);
    }

    protected String generateDocumentModelKey(DocumentModel doc) throws ClientException {
        String key = null;
        if (doc != null) {
            key = doc.getCacheKey();
        }
        return key;
    }

    protected String generateMailboxCacheKey(Mailbox mailbox) throws ClientException {
        String key = null;
        if (mailbox != null) {
            key = this.generateDocumentModelKey(mailbox.getDocument());
        }
        return key;
    }

    protected String generateCaseCacheKey(Case envelope) throws ClientException {
        String key = null;
        if (envelope != null && this.documentManager != null) {
            key = this.generateDocumentModelKey(envelope.getDocument()) + (!envelope.isEmpty() ? this.generateDocumentModelKey(envelope.getFirstItem(this.documentManager).getDocument()) : "");
        }
        return key;
    }

    protected String generateCurrentCaseItemCacheKey(DocumentModel currentEmail) throws ClientException {
        return this.generateDocumentModelKey(currentEmail);
    }

    public DocumentModel getCachedCaseItem() throws ClientException {
        return this.cachedEmail;
    }

    public Case getCachedCase() throws ClientException {
        return this.cachedEnvelope;
    }

    public Mailbox getCachedMailbox() throws ClientException {
        return this.cachedMailbox;
    }

    @Override
    public DocumentModel getCurrentCaseItem() throws ClientException {
        return this.cmContextHolder.getCurrentCaseItem();
    }

    @Override
    public Case getCurrentCase() throws ClientException {
        return this.cmContextHolder.getCurrentCase();
    }

    @Override
    public Mailbox getCurrentMailbox() throws ClientException {
        return this.cmContextHolder.getCurrentMailbox();
    }

    protected void resetMailboxCache(Mailbox cachedMailbox, Mailbox newMailbox) throws ClientException {
    }

    protected void resetCaseCache(Case cachedEnvelope, Case newEnvelope) throws ClientException {
    }

    protected void resetCurrentCaseItemCache(DocumentModel cachedEmail, DocumentModel newEmail) throws ClientException {
    }
}

