/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.comments;

import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.web.context.CaseManagementContextHolder;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.comment.web.CommentManagerActions;
import org.nuxeo.ecm.platform.comment.web.ThreadEntry;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="cmCommentActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
@CaseManagementContextBound
public class CaseManagementCommentActionsBean
extends CaseManagementContextBoundInstance {
    private static final long serialVersionUID = 6994714264125928209L;
    public static final String CASE_MANAGEMENT_COMMENT_ACTIONS = "CASE_MANAGEMENT_COMMENT_ACTIONS";
    @In(create=true)
    protected transient CommentManagerActions commentManagerActions;
    @In(create=true)
    protected transient NavigationContext navigationContext;

    @Override
    public void onMailboxContextChange(CaseManagementContextHolder correspContextHolder) throws ClientException {
        super.onMailboxContextChange(correspContextHolder);
        this.commentManagerActions.documentChanged();
    }

    @Override
    protected void resetCurrentCaseItemCache(DocumentModel cachedEmail, DocumentModel newEmail) throws ClientException {
        this.commentManagerActions.documentChanged();
    }

    public String addComment() throws ClientException {
        if (!this.isCurrentDocumentCase()) {
            return this.commentManagerActions.addComment();
        }
        return this.commentManagerActions.createComment(this.getCurrentCaseItem());
    }

    @Factory(value="caseItemThreadedComments", scope=ScopeType.EVENT)
    public List<ThreadEntry> getCommentsAsThread() throws ClientException {
        if (!this.isCurrentDocumentCase()) {
            return this.commentManagerActions.getCommentsAsThread(null);
        }
        return this.commentManagerActions.getCommentsAsThread(this.getCurrentCaseItem());
    }

    public List<Action> getActionsForComment() throws ClientException {
        if (!this.isCurrentDocumentCase()) {
            return this.commentManagerActions.getActionsForComment();
        }
        return this.commentManagerActions.getActionsForComment(CASE_MANAGEMENT_COMMENT_ACTIONS);
    }

    protected boolean isCurrentDocumentCase() {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        Case currentCase = (Case)currentDoc.getAdapter(Case.class);
        if (currentCase != null) {
            return true;
        }
        CaseItem currentCaseItem = (CaseItem)currentDoc.getAdapter(CaseItem.class);
        return currentCaseItem != null;
    }
}

