/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dev;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.dev.ConfigurationReader;

public class ConfigurationLoader {
    protected final Map<String, String> config = new HashMap<String, String>();
    protected final Set<String> bundles = new LinkedHashSet<String>();
    protected final Set<String> libs = new LinkedHashSet<String>();
    protected final Set<String> poms = new LinkedHashSet<String>();
    protected final Map<String, String> props = new HashMap<String, String>();
    protected final ConfigurationReader reader = new ConfigurationReader();
    protected ArtifactDescriptor templateArtifact;
    protected String templatePrefix;

    public ConfigurationLoader() {
        this.reader.addReader("configuration", new PropertiesReader(this.config));
        this.reader.addReader("bundles", new ArtifactReader(this.bundles));
        this.reader.addReader("libs", new ArtifactReader(this.libs));
        this.reader.addReader("properties", new PropertiesReader(this.props));
        this.reader.addReader("template", new TemplateReader());
        this.reader.addReader("poms", new ArtifactReader(this.poms));
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    public Set<String> getPoms() {
        return this.poms;
    }

    public ConfigurationReader getReader() {
        return this.reader;
    }

    public Set<String> getBundles() {
        return this.bundles;
    }

    public Set<String> getLibs() {
        return this.libs;
    }

    public boolean isOffline(boolean defaultValue) {
        if (!this.config.containsKey("offline")) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.config.get("offline"));
    }

    public int logThreshold(int defaultValue) {
        if (!this.config.containsKey("logThreshold")) {
            return defaultValue;
        }
        return Integer.parseInt(this.config.get("logThreshold"));
    }

    public ArtifactDescriptor getTemplateArtifact() {
        return this.templateArtifact;
    }

    public String getTemplatePrefix() {
        return this.templatePrefix;
    }

    public static String expandVars(String expression, Map<?, ?> properties) {
        int p = expression.indexOf("${");
        if (p == -1) {
            return expression;
        }
        char[] buf = expression.toCharArray();
        StringBuilder result = new StringBuilder(buf.length);
        if (p > 0) {
            result.append(expression.substring(0, p));
        }
        StringBuilder varBuf = new StringBuilder();
        boolean dollar = false;
        boolean var = false;
        block5: for (int i = p; i < buf.length; ++i) {
            char c = buf[i];
            switch (c) {
                case '$': {
                    dollar = true;
                    continue block5;
                }
                case '{': {
                    if (dollar) {
                        dollar = false;
                        var = true;
                        continue block5;
                    }
                    result.append(c);
                    continue block5;
                }
                case '}': {
                    if (var) {
                        var = false;
                        String varName = varBuf.toString();
                        varBuf.setLength(0);
                        Object varValue = properties.get(varName);
                        if (varValue != null) {
                            result.append(varValue.toString());
                            continue block5;
                        }
                        result.append("${").append(varName).append('}');
                        continue block5;
                    }
                    result.append(c);
                    continue block5;
                }
                default: {
                    if (var) {
                        varBuf.append(c);
                        continue block5;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    class TemplateReader
    implements ConfigurationReader.SectionReader {
        TemplateReader() {
        }

        @Override
        public void readLine(String section, String line) throws IOException {
            int p = line.indexOf(61);
            if (p == -1) {
                throw new IOException("Invalid configuration line: " + line);
            }
            String key = line.substring(0, p).trim();
            String value = line.substring(p + 1).trim();
            if ("path".equals(key)) {
                ConfigurationLoader.this.templatePrefix = ConfigurationLoader.expandVars(value, ConfigurationLoader.this.props);
            } else if ("artifact".equals(key)) {
                ConfigurationLoader.this.templateArtifact = new ArtifactDescriptor(ConfigurationLoader.expandVars(value, ConfigurationLoader.this.props));
            } else {
                throw new IOException("Unknown configuration property: " + key);
            }
        }
    }

    class PropertiesReader
    implements ConfigurationReader.SectionReader {
        final Map<String, String> map;

        public PropertiesReader(Map<String, String> map) {
            this.map = map;
        }

        @Override
        public void readLine(String section, String line) throws IOException {
            int p = line.indexOf(61);
            if (p == -1) {
                throw new IOException("Invalid properties line: " + line);
            }
            String key = line.substring(0, p).trim();
            String value = line.substring(p + 1).trim();
            this.map.put(key, value);
        }
    }

    class ArtifactReader
    implements ConfigurationReader.SectionReader {
        protected Set<String> result;

        ArtifactReader(Set<String> result) {
            this.result = result;
        }

        @Override
        public void readLine(String section, String line) throws IOException {
            this.result.add(ConfigurationLoader.expandVars(line, ConfigurationLoader.this.props));
        }
    }
}

