/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.swing.tree;

import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import javax.swing.Icon;
import org.apache.maven.project.MavenProject;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;
import org.nuxeo.build.swing.IconUtils;
import org.nuxeo.build.swing.tree.ArtifactCellRenderer;

public class ItemProvider {
    public static final ItemProvider DEFAULT = new ItemProvider();

    public String[] getRoots() {
        return null;
    }

    public boolean accept(Edge edge) {
        return true;
    }

    public boolean hasChildren(Node node) {
        return true;
    }

    public Color getForegroundColor(Node node, boolean isSelected) {
        return null;
    }

    public Color getBackgroundColor(Node node, boolean isSelected) {
        return null;
    }

    public Font getFont(Node node) {
        return null;
    }

    public Icon getIcon(Node node, boolean isExpanded) {
        String type = node.getArtifact().getType();
        return IconUtils.createImageIcon(ArtifactCellRenderer.class, type + ".gif");
    }

    public String getName(Node node) {
        return node.getArtifact().getArtifactId();
    }

    public String getTooltip(Node node) {
        return node.getId().substring(0, node.getId().length() - 1);
    }

    public String getInfo(Node node) {
        String id = node.getId().substring(0, node.getId().length() - 1);
        Collection<Edge> edgesIn = node.getEdgesIn();
        String scopes = null;
        if (edgesIn != null && !edgesIn.isEmpty()) {
            scopes = "<br>";
            for (Edge edge : edgesIn) {
                scopes = scopes + "&nbsp;&nbsp;<dd>" + edge.in.getArtifact().getArtifactId() + ": <strong><i>" + (edge.scope == null ? "compile" : edge.scope) + "</i></strong></dd><br>";
            }
        } else {
            scopes = "N/A";
        }
        MavenProject pom = node.getPomIfAlreadyLoaded();
        String desc = null;
        if (pom != null) {
            desc = "<i>" + pom.getDescription() + "</i>";
            String href = pom.getUrl();
            String fileRef = null;
            try {
                fileRef = node.getFile().toURI().toURL().toExternalForm();
            }
            catch (Exception e) {
                fileRef = "file:/" + node.getFile().getAbsolutePath();
            }
            desc = desc + "<p><b>Url:</b> " + href + "<br><b>File:</b> <a href=\"" + fileRef + "\">" + node.getFile() + "</a></p>";
        } else {
            desc = "<i><font color=\"light-gray\">Pom not loaded. Enter the artifact to load it.</font></i>";
        }
        return "<html><body><b>Artifact: </b> " + id + "<br><b>Scopes: </b>" + scopes + "<p>" + desc + "</p></body></html>";
    }
}

