/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.graph;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.graph.Graph;

public class Resolver {
    protected Graph graph;

    public Resolver(Graph graph) {
        this.graph = graph;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void resolve(Artifact artifact) {
        if (artifact.isResolved()) {
            return;
        }
        try {
            this.graph.maven.resolve(artifact);
        }
        catch (ArtifactNotFoundException e) {
            MavenClientFactory.getLog().warn("Cannot resolve " + artifact, e);
        }
    }

    public MavenProject load(Artifact artifact) {
        if ("system".equals(artifact.getScope())) {
            return null;
        }
        try {
            return this.graph.maven.getProjectBuilder().buildFromRepository(this.graph.maven.getArtifactFactory().createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()), this.graph.maven.getRemoteRepositories(), this.graph.maven.getLocalRepository());
        }
        catch (ProjectBuildingException e) {
            MavenClientFactory.getLog().error("Error loading POM of " + artifact, e);
            return null;
        }
    }
}

