/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.HashMap;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class VersionManagement {
    protected HashMap<String, String> versions;

    public String getVersion(ArtifactDescriptor ad) {
        return this.getVersion(ad.groupId, ad.artifactId, ad.type, ad.classifier);
    }

    public String getVersion(String groupId, String artifactId) {
        return this.getVersion(groupId, artifactId, "", "");
    }

    public String getVersion(String groupId, String artifactId, String type) {
        return this.getVersion(groupId, artifactId, type, "");
    }

    public String getVersion(String groupId, String artifactId, String type, String classifier) {
        String key = this.makeKey(groupId, artifactId, type, classifier);
        return this.getVersion(key);
    }

    protected String getVersion(String key) {
        this.load();
        return this.versions.get(key);
    }

    protected synchronized void load() {
        if (this.versions != null) {
            return;
        }
        this.versions = new HashMap();
        Graph graph = MavenClientFactory.getInstance().getGraph();
        for (Node root : graph.getRoots()) {
            DependencyManagement mgr = root.getPom().getDependencyManagement();
            for (Dependency dep : mgr.getDependencies()) {
                this.versions.put(this.makeKey(dep.getGroupId(), dep.getArtifactId(), dep.getType(), dep.getClassifier()), dep.getVersion());
            }
        }
    }

    private final String makeKey(String groupId, String artifactId, String type, String classifier) {
        if (artifactId == null || groupId == null) {
            throw new IllegalArgumentException("Cannot make key from " + groupId + ":" + artifactId + ":" + type + ":" + classifier + "\nBoth artifactId and groupId are required when requesting a version from dependency management.");
        }
        if (type == null) {
            type = "";
        }
        if (classifier == null) {
            classifier = "";
        }
        return artifactId + ":" + groupId + ":" + type + ":" + classifier;
    }
}

