/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class ManifestBundleCategoryPatternFilter
implements Filter {
    public static final String MANIFEST_BUNDLE_CATEGORY = "Bundle-Category";
    public static final String MANIFEST_BUNDLE_CATEGORY_TOKEN = ",";
    protected List<char[]> patterns = new ArrayList<char[]>();

    public ManifestBundleCategoryPatternFilter(String patterns) {
        StringTokenizer st = new StringTokenizer(patterns, MANIFEST_BUNDLE_CATEGORY_TOKEN);
        while (st.hasMoreTokens()) {
            this.patterns.add(st.nextToken().toCharArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getValuesToMatch(Artifact artifact) {
        ArrayList<String> valuesToMatch = new ArrayList<String>();
        File file = artifact.getFile();
        if (file == null) {
            if (artifact.isResolved()) {
                MavenClientFactory.getLog().warn("Artifact " + artifact + " doesn't contain a file");
            } else if (!"provided".equals(artifact.getScope())) {
                MavenClientFactory.getLog().warn("Artifact " + artifact + " unresolved");
            }
            return valuesToMatch;
        }
        if (!file.getName().endsWith(".jar")) {
            return valuesToMatch;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file, true);
            Manifest mf = jarFile.getManifest();
            if (mf != null) {
                String bundleCategories;
                Attributes attributes = mf.getMainAttributes();
                if (attributes != null && (bundleCategories = attributes.getValue(MANIFEST_BUNDLE_CATEGORY)) != null) {
                    StringTokenizer st = new StringTokenizer(bundleCategories, MANIFEST_BUNDLE_CATEGORY_TOKEN);
                    while (st.hasMoreTokens()) {
                        valuesToMatch.add(st.nextToken());
                    }
                }
            } else {
                MavenClientFactory.getLog().warn("Artifact " + artifact + " doesn't contain a manifest");
            }
        }
        catch (IOException e) {
            MavenClientFactory.getLog().error("error while inspecting this jar manifest: " + artifact.getFile(), e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    MavenClientFactory.getLog().error(e.getMessage(), e);
                }
            }
        }
        return valuesToMatch;
    }

    @Override
    public boolean accept(Node node) {
        return this.accept(node.getArtifact());
    }

    public boolean accept(Edge edge, Dependency dep) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean accept(Edge edge) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean accept(Artifact artifact) {
        if (!artifact.getGroupId().startsWith("org.nuxeo")) {
            return false;
        }
        boolean include = this.matchPattern(this.getValuesToMatch(artifact));
        if (MavenClientFactory.getLog().isDebugEnabled()) {
            MavenClientFactory.getLog().debug((include ? "accepts " : "rejects ") + artifact);
        }
        return include;
    }

    private boolean matchPattern(List<String> valuesToMatch) {
        for (String valueToMatch : valuesToMatch) {
            for (char[] pattern : this.patterns) {
                if (!this.matchPattern(valueToMatch, pattern)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchPattern(String name, char[] pattern) {
        return this.matchPattern(name.toCharArray(), pattern);
    }

    public boolean matchPattern(char[] name, char[] pattern) {
        return this.matchPattern(name, 0, name.length, pattern);
    }

    public boolean matchPattern(char[] name, int offset, int len, char[] pattern) {
        int i = offset;
        boolean wildcard = false;
        block4: for (char c : pattern) {
            switch (c) {
                case '*': {
                    wildcard = true;
                    continue block4;
                }
                case '?': {
                    ++i;
                    continue block4;
                }
                default: {
                    if (wildcard) {
                        while (i < len && name[i++] != c) {
                        }
                        if (i == len) {
                            return true;
                        }
                        wildcard = false;
                        continue block4;
                    }
                    if (i >= len || name[i] != c) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return wildcard || i == len;
    }
}

