/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.SegmentMatch;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class ClassifierFilter
implements Filter {
    protected SegmentMatch matcher;

    public String toString() {
        return "" + this.getClass() + " [" + this.matcher + "]";
    }

    public ClassifierFilter(String pattern) {
        this(SegmentMatch.parse(pattern));
    }

    public ClassifierFilter(SegmentMatch matcher) {
        this.matcher = matcher;
    }

    public boolean match(String segment) {
        return this.matcher.match(segment);
    }

    public boolean accept(Edge edge, Dependency dep) {
        String classifier = dep.getClassifier();
        if (classifier == null) {
            return this.matcher == SegmentMatch.ANY;
        }
        return this.matcher.match(dep.getClassifier());
    }

    @Override
    public boolean accept(Edge edge) {
        return this.accept(edge.out.getArtifact());
    }

    @Override
    public boolean accept(Artifact artifact) {
        String classifier = artifact.getClassifier();
        if (classifier == null) {
            return this.matcher == SegmentMatch.ANY;
        }
        return this.matcher.match(classifier);
    }

    @Override
    public boolean accept(Node node) {
        return this.accept(node.getArtifact());
    }
}

