/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.nuxeo.build.maven.ArtifactDescriptor;
import org.nuxeo.build.maven.filter.ArtifactIdFilter;
import org.nuxeo.build.maven.filter.EdgeFilter;
import org.nuxeo.build.maven.filter.Filter;
import org.nuxeo.build.maven.filter.GroupIdFilter;
import org.nuxeo.build.maven.filter.TypeFilter;
import org.nuxeo.build.maven.filter.VersionFilter;
import org.nuxeo.build.maven.graph.Edge;
import org.nuxeo.build.maven.graph.Node;

public class AncestorFilter
implements Filter {
    protected ArtifactDescriptor ad;
    protected List<EdgeFilter> filters;

    public AncestorFilter(String pattern) {
        this.ad = new ArtifactDescriptor(pattern);
        this.filters = new ArrayList<EdgeFilter>();
        if (this.ad.groupId != null && !this.ad.groupId.equals("*")) {
            this.addFilter(new GroupIdFilter(this.ad.groupId));
        }
        if (this.ad.artifactId != null && !this.ad.artifactId.equals("*")) {
            this.addFilter(new ArtifactIdFilter(this.ad.artifactId));
        }
        if (this.ad.version != null && !this.ad.version.equals("*")) {
            this.addFilter(new VersionFilter(this.ad.version));
        }
        if (this.ad.type != null && !this.ad.type.equals("*")) {
            this.addFilter(new TypeFilter(this.ad.type));
        }
        if (this.ad.classifier != null && !this.ad.classifier.equals("*")) {
            this.addFilter(new GroupIdFilter(this.ad.classifier));
        }
        if (this.ad.scope != null && !this.ad.scope.equals("*")) {
            this.addFilter(new GroupIdFilter(this.ad.scope));
        }
    }

    protected void addFilter(EdgeFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public boolean accept(Node node) {
        for (Edge edge : node.getEdgesIn()) {
            if (!this.accept(edge)) continue;
            return true;
        }
        return false;
    }

    public boolean accept(Edge edge, Dependency dep) {
        throw new UnsupportedOperationException("Ancestor folder cannot be applied on dependency objects");
    }

    @Override
    public boolean accept(Edge edge) {
        int len = this.filters.size();
        for (int i = 0; i < len; ++i) {
            if (this.filters.get(i).accept(edge)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(Artifact artifact) {
        throw new UnsupportedOperationException("Ancestor folder cannot be applied on artifact objects");
    }
}

