/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import org.nuxeo.build.maven.EmbeddedMavenClient;
import org.nuxeo.build.maven.Logger;
import org.nuxeo.build.maven.MavenClient;

public class MavenClientFactory {
    private static boolean isEmbedded;
    private static MavenClient instance;
    private static ThreadLocal<MavenClient> threadInstance;

    public static void setInstance(MavenClient client) {
        if (client instanceof EmbeddedMavenClient) {
            isEmbedded = true;
            instance = client;
        } else {
            isEmbedded = false;
            threadInstance.set(client);
        }
    }

    public static boolean isEmbedded() {
        return isEmbedded;
    }

    public static MavenClient getInstance() {
        if (isEmbedded) {
            return instance;
        }
        return threadInstance.get();
    }

    public static EmbeddedMavenClient getEmbeddedMaven() {
        if (isEmbedded) {
            return (EmbeddedMavenClient)instance;
        }
        throw new IllegalStateException("Not an embedded maven client. You can run this task only in embedded mode");
    }

    public static Logger getLog() {
        return MavenClientFactory.getInstance().getCommonLogger();
    }

    static {
        threadInstance = new ThreadLocal();
    }
}

