/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.surefire.failsafe.model.FailsafeSummary;
import org.apache.maven.surefire.failsafe.model.io.xpp3.FailsafeSummaryXpp3Writer;
import org.codehaus.plexus.util.IOUtil;
import org.nuxeo.build.maven.AntBuildMojo;

public class IntegrationTestMojo
extends AntBuildMojo {
    private boolean testFailureIgnore;
    private File summaryFile;

    public boolean isTestFailureIgnore() {
        return this.testFailureIgnore;
    }

    public void setTestFailureIgnore(boolean testFailureIgnore) {
        this.testFailureIgnore = testFailureIgnore;
    }

    public File getSummaryFile() {
        return this.summaryFile;
    }

    public void setSummaryFile(File summaryFile) {
        this.summaryFile = summaryFile;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        FailsafeSummary result = new FailsafeSummary();
        this.summaryFile.delete();
        try {
            super.execute();
        }
        catch (MojoExecutionException e) {
            if (!this.isTestFailureIgnore()) {
                throw e;
            }
            this.getLog().error((CharSequence)e.getMessage());
            result.setResult(255);
            result.setException(e.getMessage());
            this.writeSummary(result);
        }
    }

    private void writeSummary(FailsafeSummary summary) throws MojoExecutionException {
        if (!this.summaryFile.getParentFile().isDirectory()) {
            this.summaryFile.getParentFile().mkdirs();
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.summaryFile)), this.getEncoding());
            FailsafeSummaryXpp3Writer xpp3Writer = new FailsafeSummaryXpp3Writer();
            xpp3Writer.write((Writer)writer, summary);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }
}

