/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.maven;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DefaultArtifactCollector;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.tools.ant.BuildException;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.build.ant.AntClient;
import org.nuxeo.build.ant.profile.AntProfileManager;
import org.nuxeo.build.maven.Logger;
import org.nuxeo.build.maven.MavenClient;
import org.nuxeo.build.maven.MavenClientFactory;
import org.nuxeo.build.maven.filter.TrueFilter;
import org.nuxeo.build.maven.graph.Graph;
import org.nuxeo.build.maven.graph.Node;

public class AntBuildMojo
extends AbstractMojo
implements MavenClient {
    protected Graph graph;
    protected AntProfileManager antProfileManager;
    protected File buildFile;
    protected File[] buildFiles;
    protected String target;
    protected String[] targets;
    protected int expand;
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    protected ArtifactRepository localRepository;
    protected List<ArtifactRepository> remoteRepositories;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected MavenProjectBuilder projectBuilder;
    protected ArtifactMetadataSource metadataSource;
    private String encoding;
    protected WagonManager wagonManager;
    protected MavenSettingsBuilder settingsBuilder;
    private Logger logger;

    public String getEncoding() {
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            this.encoding = ReaderFactory.FILE_ENCODING;
        }
        return this.encoding;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        AntClient ant = new AntClient();
        MavenClientFactory.setInstance(this);
        this.wagonManager.setInteractive(false);
        this.logger = new Logger(){

            @Override
            public void debug(String message) {
                AntBuildMojo.this.getLog().debug((CharSequence)message);
            }

            @Override
            public void debug(String message, Throwable error) {
                AntBuildMojo.this.getLog().debug((CharSequence)message, error);
            }

            @Override
            public void error(String message) {
                AntBuildMojo.this.getLog().error((CharSequence)message);
            }

            @Override
            public void error(String message, Throwable error) {
                AntBuildMojo.this.getLog().error((CharSequence)message, error);
            }

            @Override
            public void info(String message) {
                AntBuildMojo.this.getLog().info((CharSequence)message);
            }

            @Override
            public void info(String message, Throwable error) {
                AntBuildMojo.this.getLog().info((CharSequence)message, error);
            }

            @Override
            public void warn(String message) {
                AntBuildMojo.this.getLog().warn((CharSequence)message);
            }

            @Override
            public void warn(String message, Throwable error) {
                AntBuildMojo.this.getLog().warn((CharSequence)message, error);
            }

            @Override
            public boolean isDebugEnabled() {
                return AntBuildMojo.this.getLog().isDebugEnabled();
            }

            @Override
            public void info(Throwable error) {
                AntBuildMojo.this.getLog().info(error);
            }

            @Override
            public void warn(Throwable error) {
                AntBuildMojo.this.getLog().warn(error);
            }

            @Override
            public void error(Throwable error) {
                AntBuildMojo.this.getLog().error(error);
            }

            @Override
            public void debug(Throwable error) {
                AntBuildMojo.this.getLog().debug(error);
            }
        };
        this.antProfileManager = new AntProfileManager();
        HashMap<String, String> props = new HashMap<String, String>();
        for (String key : this.project.getProperties().stringPropertyNames()) {
            props.put(key, this.project.getProperties().getProperty(key));
        }
        props.put("maven.basedir", this.project.getBasedir().getAbsolutePath());
        props.put("maven.project.name", this.project.getName());
        props.put("maven.project.artifactId", this.project.getArtifactId());
        props.put("maven.project.groupId", this.project.getGroupId());
        props.put("maven.project.version", this.project.getVersion());
        props.put("maven.project.packaging", this.project.getPackaging());
        props.put("maven.project.id", this.project.getId());
        props.put("maven.project.build.directory", this.project.getBuild().getDirectory());
        props.put("maven.project.build.outputDirectory", this.project.getBuild().getOutputDirectory());
        props.put("maven.project.build.finalName", this.project.getBuild().getFinalName());
        props.put("maven.offline", this.wagonManager.isOnline() ? "" : "-o");
        List<Profile> profiles = this.getActiveProfiles();
        for (Profile profile : profiles) {
            this.antProfileManager.activateProfile(profile.getId(), true);
            props.put("maven.profile." + profile.getId(), "true");
            for (String key : profile.getProperties().stringPropertyNames()) {
                props.put(key, profile.getProperties().getProperty(key));
            }
        }
        props.putAll(System.getProperties());
        ant.setGlobalProperties(props);
        if (this.buildFile != null && this.buildFiles != null && this.buildFiles.length > 0) {
            throw new MojoExecutionException("The configuration parameters 'buildFile' and 'buildFiles' cannot both be used.");
        }
        if (this.buildFiles == null || this.buildFiles.length == 0) {
            if (this.buildFile == null) {
                this.buildFile = new File("build.xml");
            }
            this.buildFiles = new File[]{this.buildFile};
        }
        if (this.target != null && this.targets != null && this.targets.length > 0) {
            throw new MojoExecutionException("The configuration parameters 'target' and 'targets' cannot both be used.");
        }
        if ((this.targets == null || this.targets.length == 0) && this.target != null) {
            this.targets = new String[]{this.target};
        }
        for (File file : this.buildFiles) {
            this.newGraph();
            if (this.expand > 0) {
                for (Node rootNode : this.graph.getRoots()) {
                    this.graph.resolveDependencyTree(rootNode, new TrueFilter(), this.expand);
                }
            }
            try {
                if (this.targets != null && this.targets.length > 0) {
                    ant.run(file, Arrays.asList(this.targets));
                    continue;
                }
                ant.run(file);
            }
            catch (BuildException e) {
                throw new MojoExecutionException("Error occurred while running " + file + ": " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    @Override
    public Graph newGraph() {
        this.graph = new Graph(this);
        this.graph.addRootNode(this.project);
        return this.graph;
    }

    @Override
    public List<Profile> getActiveProfiles() {
        return this.project.getActiveProfiles();
    }

    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public ArtifactFactory getArtifactFactory() {
        return this.factory;
    }

    @Override
    public ArtifactResolver getArtifactResolver() {
        return this.resolver;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public MavenProjectBuilder getProjectBuilder() {
        return this.projectBuilder;
    }

    @Override
    public MavenProjectHelper getProjectHelper() {
        return this.projectHelper;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public void resolve(Artifact artifact, List<ArtifactRepository> otherRemoteRepositories) throws ArtifactNotFoundException {
        try {
            this.resolver.resolve(artifact, otherRemoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
        catch (ArtifactNotFoundException e) {
            this.tryResolutionOnLocalBaseVersion(artifact, e);
        }
    }

    @Override
    public void resolve(Artifact artifact) throws ArtifactNotFoundException {
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e);
        }
        catch (ArtifactNotFoundException e) {
            this.tryResolutionOnLocalBaseVersion(artifact, e);
        }
    }

    protected void tryResolutionOnLocalBaseVersion(Artifact artifact, ArtifactNotFoundException e) throws ArtifactNotFoundException {
        String resolvedVersion = artifact.getVersion();
        artifact.updateVersion(artifact.getBaseVersion(), this.localRepository);
        File localFile = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
        if (!localFile.exists()) {
            artifact.updateVersion(resolvedVersion, this.localRepository);
            throw e;
        }
        this.getLog().warn((CharSequence)String.format("Couldn't resolve %s, fallback on local install of unique version %s.", resolvedVersion, artifact.getBaseVersion()));
        artifact.setResolved(true);
    }

    @Override
    public void resolveDependencyTree(Artifact artifact, ArtifactFilter filter, ResolutionListener listener) throws ArtifactResolutionException, ProjectBuildingException {
        MavenProject mavenProject = this.projectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository);
        DefaultArtifactCollector collector = new DefaultArtifactCollector();
        collector.collect(mavenProject.getDependencyArtifacts(), mavenProject.getArtifact(), mavenProject.getManagedVersionMap(), this.localRepository, mavenProject.getRemoteArtifactRepositories(), this.metadataSource, filter, Collections.singletonList(listener));
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public AntProfileManager getAntProfileManager() {
        return this.antProfileManager;
    }

    @Override
    public Logger getCommonLogger() {
        return this.logger;
    }
}

