/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import org.apache.tools.ant.types.DataType;
import org.nuxeo.build.maven.filter.AncestorFilter;
import org.nuxeo.build.maven.filter.AndFilter;
import org.nuxeo.build.maven.filter.ArtifactIdFilter;
import org.nuxeo.build.maven.filter.ClassifierFilter;
import org.nuxeo.build.maven.filter.GroupIdFilter;
import org.nuxeo.build.maven.filter.IsOptionalFilter;
import org.nuxeo.build.maven.filter.ManifestBundleCategoryFilter;
import org.nuxeo.build.maven.filter.ScopeFilter;
import org.nuxeo.build.maven.filter.TypeFilter;
import org.nuxeo.build.maven.filter.VersionFilter;

public class ArtifactPattern
extends DataType {
    private AndFilter filter = new AndFilter();
    protected String category = null;
    protected String groupId = null;
    protected String artifactId = null;
    protected String version = null;
    protected String classifier = null;
    protected String type = null;
    protected String scope = "!test";
    protected boolean isOptional = false;
    protected String pattern = null;
    protected String ancestor = null;
    protected boolean isDependsOnCategory = true;
    private ManifestBundleCategoryFilter categoryFilter = null;

    public AndFilter getFilter() {
        return this.filter;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
        this.filter.addFilter(GroupIdFilter.class, groupId);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        this.filter.addFilter(ArtifactIdFilter.class, artifactId);
    }

    public void setVersion(String version) {
        this.version = version;
        this.filter.addFilter(VersionFilter.class, version);
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
        this.filter.addFilter(ClassifierFilter.class, classifier);
    }

    public void setType(String type) {
        this.type = type;
        this.filter.addFilter(TypeFilter.class, type);
    }

    public void setScope(String scope) {
        this.scope = scope;
        this.filter.addFilter(ScopeFilter.class, scope);
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
        if (isOptional) {
            this.filter.addFilter(new IsOptionalFilter(isOptional));
        }
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.filter.addFiltersFromPattern(pattern);
    }

    public void setAncestor(String ancestor) {
        this.ancestor = ancestor;
        this.filter.addFilter(AncestorFilter.class, ancestor);
    }

    public void setCategory(String category) {
        this.category = category;
        this.categoryFilter = new ManifestBundleCategoryFilter(category, this.isDependsOnCategory);
        this.filter.addFilter(this.categoryFilter);
    }

    public void setDependsOnCategory(boolean isDependsOnCategory) {
        this.isDependsOnCategory = isDependsOnCategory;
        if (this.categoryFilter != null && !isDependsOnCategory) {
            this.categoryFilter.setDependsOnCategory(false);
        }
    }
}

