/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant.artifact;

import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Sequential;
import org.nuxeo.build.ant.artifact.ArtifactSet;
import org.nuxeo.build.maven.graph.Node;

public class ArtifactForeach
extends Sequential {
    public String property;
    public ArtifactSet artifactSet;

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public ArtifactSet getArtifactSet() {
        return this.artifactSet;
    }

    public void setSetref(String setref) {
        this.artifactSet = (ArtifactSet)((Object)this.getProject().getReference(setref));
    }

    public void execute() throws BuildException {
        for (Node node : this.artifactSet.getNodes()) {
            String canonicalPath = null;
            try {
                canonicalPath = node.getFile().getCanonicalPath();
            }
            catch (IOException e) {
                this.log("An error occurred while getting artifact file canonical path", e, 1);
            }
            this.getProject().setProperty(this.property + ".file.path", canonicalPath);
            this.getProject().setProperty(this.property + ".archetypeId", node.getArtifact().getArtifactId());
            this.getProject().setProperty(this.property + ".groupId", node.getArtifact().getGroupId());
            this.getProject().setProperty(this.property + ".version", node.getArtifact().getBaseVersion());
            try {
                super.execute();
            }
            catch (Throwable e) {
                this.log("Couldn't execute the task for artifact " + node.getId(), e, 2);
            }
        }
    }
}

