/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.build.ant;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Task;
import org.nuxeo.build.maven.MavenClientFactory;

public class PropertyRegexp
extends Task {
    String property;
    String pattern;
    String input;
    int select = 0;

    public void setProperty(String property) {
        this.property = property;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setSelect(int select) {
        this.select = select;
    }

    public void execute() {
        try {
            String inputString = PropertyRegexp.readFileAsString(this.input);
            Pattern p = Pattern.compile(this.pattern);
            Matcher m = p.matcher(inputString);
            String findString = "";
            if (m.find()) {
                findString = m.group(this.select);
            }
            this.getProject().setProperty(this.property, findString);
        }
        catch (IOException e) {
            MavenClientFactory.getLog().error("Couldn't read " + this.input, e);
        }
    }

    private static String readFileAsString(String filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        return fileData.toString();
    }
}

