/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.mgcp.stack;

import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.DeleteProviderException;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpStack;
import jain.protocol.ip.mgcp.OAM_IF;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.mgcp.parser.UtilsFactory;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackProviderImpl;
import org.mobicents.protocols.mgcp.stack.MessageHandler;
import org.mobicents.protocols.mgcp.stack.TransactionHandler;
import org.mobicents.protocols.mgcp.utils.PacketRepresentation;
import org.mobicents.protocols.mgcp.utils.PacketRepresentationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JainMgcpStackImpl
extends Thread
implements JainMgcpStack,
OAM_IF {
    public static final String _EXECUTOR_TABLE_SIZE = "executorTableSize";
    public static final String _EXECUTOR_QUEUE_SIZE = "executorQueueSize";
    public static final String _MESSAGE_READER_THREAD_PRIORITY = "messageReaderThreadPriority";
    private static final Logger logger = Logger.getLogger(JainMgcpStackImpl.class);
    private static final String propertiesFileName = "mgcp-stack.properties";
    private String protocolVersion = "1.0";
    protected int port = 2727;
    private InetAddress localAddress = null;
    private boolean stopped = true;
    private int messageReaderThreadPriority = 1;
    private UtilsFactory utilsFactory = null;
    private PacketRepresentationFactory prFactory = null;
    private static final int BUFFER_SIZE = 5000;
    private DatagramChannel channel;
    ByteBuffer receiveBuffer = ByteBuffer.allocateDirect(5000);
    ByteBuffer sendBuffer = ByteBuffer.allocateDirect(5000);
    byte[] b = new byte[5000];
    public JainMgcpStackProviderImpl provider = null;
    private InetSocketAddress address = null;
    private ConcurrentHashMap<Integer, TransactionHandler> localTransactions = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Integer> remoteTxToLocalTxMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, TransactionHandler> completedTransactions = new ConcurrentHashMap();
    protected MessageHandler messageHandler = null;
    private DatagramSocket socket;
    private long delay = 20L;

    public void printStats() {
        System.out.println("localTransactions size = " + this.localTransactions.size());
        System.out.println("remoteTxToLocalTxMap size = " + this.remoteTxToLocalTxMap.size());
        System.out.println("completedTransactions size = " + this.completedTransactions.size());
    }

    public JainMgcpStackImpl() {
    }

    public JainMgcpStackImpl(InetAddress localAddress, int port) {
        this.localAddress = localAddress;
        this.port = port;
    }

    private void init() throws IOException {
        this.readProperties();
        if (this.channel == null) {
            try {
                InetSocketAddress bindAddress = new InetSocketAddress(this.localAddress, this.port);
                this.channel = DatagramChannel.open();
                this.socket = this.channel.socket();
                this.socket.bind(bindAddress);
                this.channel.configureBlocking(false);
                this.localAddress = this.socket.getLocalAddress();
                logger.info((Object)("Jain Mgcp stack bound to IP " + this.localAddress + " and UDP port " + this.port));
                System.out.println("Jain Mgcp stack bound to IP " + this.localAddress + " and UDP port " + this.port);
            }
            catch (SocketException e) {
                logger.error((Object)e);
                throw new RuntimeException("Failed to find a local port " + this.port + " to bound stack");
            }
        }
        this.stopped = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting main thread " + this));
        }
        this.provider = new JainMgcpStackProviderImpl(this);
        this.utilsFactory = new UtilsFactory(25);
        this.prFactory = new PacketRepresentationFactory(50, 5000);
        this.messageHandler = new MessageHandler(this);
        this.setPriority(this.messageReaderThreadPriority);
        this.setDaemon(false);
        this.start();
    }

    private void readProperties() {
        try {
            Properties props = new Properties();
            InputStream is = this.getClass().getResourceAsStream(propertiesFileName);
            if (is == null) {
                logger.warn((Object)"Failed to locate properties file, using default values");
                return;
            }
            props.load(is);
            String val = null;
            val = props.getProperty(_MESSAGE_READER_THREAD_PRIORITY, "" + this.messageReaderThreadPriority);
            this.messageReaderThreadPriority = Integer.parseInt(val);
            val = null;
            logger.info((Object)(propertiesFileName + " read successfully! \nmessageReaderThreadPriority = " + this.messageReaderThreadPriority));
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to read properties file due to some error \"" + e.getMessage() + "\", using defualt values!!!!"));
        }
    }

    public void close() {
        block4: {
            this.stopped = true;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Closing socket");
                }
                this.socket.close();
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block4;
                logger.error((Object)"Could not gracefully close socket", (Throwable)e);
            }
        }
    }

    public JainMgcpProvider createProvider() throws CreateProviderException {
        if (this.provider != null) {
            throw new CreateProviderException("Provider already created. Only 1 provider can be created. Delete the first and then re-create");
        }
        try {
            this.init();
        }
        catch (IOException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)"Failed to open Socket ", (Throwable)e);
            }
            throw new CreateProviderException(e.getMessage());
        }
        return this.provider;
    }

    public void deleteProvider(JainMgcpProvider provider) throws DeleteProviderException {
        if (this.provider == null) {
            throw new DeleteProviderException("No Provider exist.");
        }
        if (this.provider != provider) {
            throw new DeleteProviderException("Passed provider is not current one.");
        }
        this.close();
        this.provider = null;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public UtilsFactory getUtilsFactory() {
        return this.utilsFactory;
    }

    public void setUtilsFactory(UtilsFactory utilsFactory) {
        this.utilsFactory = utilsFactory;
    }

    public InetAddress getAddress() {
        if (this.localAddress != null) {
            return this.localAddress;
        }
        return null;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    protected synchronized void send(byte[] data, SocketAddress address) {
        block2: {
            try {
                this.sendBuffer.clear();
                this.sendBuffer.put(data);
                this.sendBuffer.flip();
                this.channel.send(this.sendBuffer, address);
            }
            catch (IOException e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block2;
                logger.error((Object)"I/O Exception uccured, caused by", (Throwable)e);
            }
        }
    }

    public boolean isRequest(String header) {
        return header.matches("[\\w]{4}(\\s|\\S)*");
    }

    @Override
    public void run() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MGCP stack started successfully on " + this.localAddress + ":" + this.port));
        }
        int length = 0;
        long start = 0L;
        long finish = 0L;
        long drift = 0L;
        long latency = 0L;
        while (!this.stopped) {
            start = System.currentTimeMillis();
            try {
                do {
                    this.receiveBuffer.clear();
                    this.address = (InetSocketAddress)this.channel.receive(this.receiveBuffer);
                    this.receiveBuffer.flip();
                    length = this.receiveBuffer.limit();
                    if (length == 0) continue;
                    this.receiveBuffer.get(this.b, 0, length);
                    PacketRepresentation pr = this.prFactory.allocate();
                    pr.setRawData(this.b);
                    pr.setLength(length);
                    pr.setRemoteAddress(this.address.getAddress());
                    pr.setRemotePort(this.address.getPort());
                    this.messageHandler.scheduleMessages(pr);
                } while (this.address != null);
                this.provider.flush();
                finish = System.currentTimeMillis();
                drift = finish - start;
                latency = this.delay - drift;
                if (latency < 5L) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(latency);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            catch (IOException e) {
                if (this.stopped) break;
                if (!logger.isEnabledFor((Priority)Level.ERROR)) continue;
                logger.error((Object)"I/O exception occured:", (Throwable)e);
            }
            catch (Exception e) {
                if (this.stopped) break;
                if (!logger.isEnabledFor((Priority)Level.ERROR)) continue;
                logger.error((Object)"Unexpected exception occured:", (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MGCP stack stopped gracefully on" + this.localAddress + ":" + this.port));
        }
    }

    public Map<Integer, TransactionHandler> getLocalTransactions() {
        return this.localTransactions;
    }

    public Map<Integer, Integer> getRemoteTxToLocalTxMap() {
        return this.remoteTxToLocalTxMap;
    }

    public Map<Integer, TransactionHandler> getCompletedTransactions() {
        return this.completedTransactions;
    }

    public void setTransactionRate(int rate) {
        this.delay = 1000 / rate;
    }

    static class ThreadFactoryImpl
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        protected int priority = 5;
        protected boolean isDaemonFactory = false;

        ThreadFactoryImpl() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "JainMgcpStackImpl-FixedThreadPool-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 5L);
            t.setDaemon(this.isDaemonFactory);
            t.setPriority(this.priority);
            return t;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public boolean isDaemonFactory() {
            return this.isDaemonFactory;
        }

        public void setDaemonFactory(boolean isDaemonFactory) {
            this.isDaemonFactory = isDaemonFactory;
        }
    }
}

