/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.tx;

import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.context.ThreadLocalSessionContext;
import org.jbpm.test.tx.TxCommand;
import org.jbpm.test.tx.VoidTxCommand;

public class TxTemplate {
    private SessionFactory sessionFactory;

    public TxTemplate(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(TxCommand txCommand) {
        Session session = this.sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        ThreadLocalSessionContext.bind((org.hibernate.Session)session);
        try {
            Object object = txCommand.execute((org.hibernate.Session)session);
            return object;
        }
        catch (Exception e) {
            transaction.rollback();
        }
        finally {
            ThreadLocalSessionContext.unbind((SessionFactory)this.sessionFactory);
            if (!transaction.wasRolledBack()) {
                transaction.commit();
            }
            session.close();
        }
        return null;
    }

    public void execute(VoidTxCommand voidTxCommand) {
        this.execute(new VoidWrapper(voidTxCommand));
    }

    static class VoidWrapper
    extends TxCommand {
        VoidTxCommand voidTxCommand;

        public VoidWrapper(VoidTxCommand voidTxCommand) {
            this.voidTxCommand = voidTxCommand;
            this.params = voidTxCommand.params;
        }

        public Object execute(org.hibernate.Session session) {
            this.voidTxCommand.execute(session);
            return null;
        }
    }
}

