/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.assertion;

import java.lang.reflect.Method;
import java.util.List;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryAssertions {
    private QueryAssertions() {
    }

    public static <T> void assertOrderOnProperty(Class<T> clazz, String property, List<T> listOrderedAsc, List<T> listOrderedDesc, List<Object> expectedValuesAsc) {
        Assert.assertNotNull(listOrderedAsc);
        Assert.assertEquals((int)expectedValuesAsc.size(), (int)expectedValuesAsc.size());
        Assert.assertNotNull(listOrderedDesc);
        Assert.assertEquals((int)expectedValuesAsc.size(), (int)listOrderedDesc.size());
        for (int i = 0; i < expectedValuesAsc.size(); ++i) {
            Object realValueAsc = null;
            Object realValueDesc = null;
            try {
                realValueAsc = QueryAssertions.invokeGetter(property, clazz, listOrderedAsc.get(i));
                realValueDesc = QueryAssertions.invokeGetter(property, clazz, listOrderedDesc.get(i));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            Assert.assertEquals((String)("Incorrect order by ASC for property " + property), (Object)expectedValuesAsc.get(i), (Object)realValueAsc);
            Assert.assertEquals((String)("Incorrect order by DESC for property " + property), (Object)expectedValuesAsc.get(listOrderedDesc.size() - 1 - i), (Object)realValueDesc);
        }
    }

    public static <T> void assertOrderIsNatural(Class<T> clazz, String property, List<T> listOrderedAsc, List<T> listOrderedDesc, int nrOfExpectedElements) {
        Assert.assertEquals((int)nrOfExpectedElements, (int)listOrderedAsc.size());
        Assert.assertEquals((int)nrOfExpectedElements, (int)listOrderedDesc.size());
        if (nrOfExpectedElements > 1) {
            for (int i = 1; i < listOrderedAsc.size(); ++i) {
                Comparable c1 = (Comparable)QueryAssertions.invokeGetter(property, clazz, listOrderedAsc.get(i - 1));
                Comparable c2 = (Comparable)QueryAssertions.invokeGetter(property, clazz, listOrderedAsc.get(i));
                if (c1 != null && c2 != null) {
                    Assert.assertTrue((String)"The ascending list does not have a natural order", (c1.compareTo(c2) <= 0 ? 1 : 0) != 0);
                }
                Comparable c3 = (Comparable)QueryAssertions.invokeGetter(property, clazz, listOrderedDesc.get(i - 1));
                Comparable c4 = (Comparable)QueryAssertions.invokeGetter(property, clazz, listOrderedDesc.get(i));
                if (c3 == null || c4 == null) continue;
                Assert.assertTrue((String)"The descending list does not have a natural order", (c3.compareTo(c4) >= 0 ? 1 : 0) != 0);
            }
        }
    }

    private static <T> Object invokeGetter(String property, Class<T> clazz, T obj) {
        try {
            Method getter = clazz.getMethod("get" + property.substring(0, 1).toUpperCase() + property.substring(1), new Class[0]);
            return getter.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't invoke getter for property " + property);
        }
    }
}

