/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jbpm.api.Configuration;
import org.jbpm.api.Execution;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.HistoryService;
import org.jbpm.api.IdentityService;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ManagementService;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskService;
import org.jbpm.api.task.Task;
import org.jbpm.test.BaseJbpmTestCase;
import org.jbpm.test.Db;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JbpmTestCase
extends BaseJbpmTestCase {
    protected static ProcessEngine processEngine = null;
    protected static RepositoryService repositoryService;
    protected static ExecutionService executionService;
    protected static ManagementService managementService;
    protected static TaskService taskService;
    protected static HistoryService historyService;
    protected static IdentityService identityService;
    protected List<String> registeredDeployments = new ArrayList<String>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.initialize();
    }

    protected synchronized void initialize() {
        if (processEngine == null) {
            processEngine = Configuration.getProcessEngine();
            repositoryService = (RepositoryService)processEngine.get(RepositoryService.class);
            executionService = processEngine.getExecutionService();
            historyService = processEngine.getHistoryService();
            managementService = processEngine.getManagementService();
            taskService = processEngine.getTaskService();
            identityService = processEngine.getIdentityService();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        this.deleteRegisteredDeployments();
        String errorMsg = this.verifyDbClean();
        super.tearDown();
        if (errorMsg != null) {
            if (this.exception == null) {
                throw new JbpmException(errorMsg);
            }
            throw new JbpmException(errorMsg, this.exception);
        }
    }

    protected String verifyDbClean() {
        String errorMsg = null;
        String recordsLeftMsg = Db.verifyClean(processEngine);
        if (recordsLeftMsg != null && recordsLeftMsg.length() > 0) {
            errorMsg = "database was not clean after test: " + recordsLeftMsg;
        }
        return errorMsg;
    }

    protected void deleteRegisteredDeployments() {
        for (String deploymentId : this.registeredDeployments) {
            repositoryService.deleteDeploymentCascade(deploymentId);
        }
    }

    public String deployJpdlXmlString(String jpdlXmlString) {
        String deploymentDbid = repositoryService.createDeployment().addResourceFromString("xmlstring.jpdl.xml", jpdlXmlString).deploy();
        this.registerDeployment(deploymentDbid);
        return deploymentDbid;
    }

    protected void registerDeployment(String deploymentId) {
        this.registeredDeployments.add(deploymentId);
    }

    public static void assertContainsTask(List<Task> taskList, String taskName) {
        if (JbpmTestCase.getTask(taskList, taskName) == null) {
            JbpmTestCase.fail((String)("tasklist doesn't contain task '" + taskName + "': " + taskList));
        }
    }

    public static void assertContainsTask(List<Task> taskList, String taskName, String assignee) {
        if (JbpmTestCase.getTask(taskList, taskName, assignee) == null) {
            JbpmTestCase.fail((String)("tasklist doesn't contain task '" + taskName + "' for assignee '" + assignee + "': " + taskList));
        }
    }

    public static Task getTask(List<Task> taskList, String taskName) {
        for (Task task : taskList) {
            if (!taskName.equals(task.getName())) continue;
            return task;
        }
        return null;
    }

    public static Task getTask(List<Task> taskList, String taskName, String assignee) {
        for (Task task : taskList) {
            if (!taskName.equals(task.getName()) || !(assignee == null ? task.getAssignee() == null : assignee.equals(task.getAssignee()))) continue;
            return task;
        }
        return null;
    }

    public void assertNoOpenTasks(String processInstanceId) {
        List tasks = taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        JbpmTestCase.assertTrue((String)("There were still open tasks found for the process instance with id " + processInstanceId + ". Current tasks are: " + this.listAllOpenTasks(processInstanceId)), (boolean)tasks.isEmpty());
    }

    protected String listAllOpenTasks(String processInstanceId) {
        List tasks = taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        StringBuilder result = new StringBuilder();
        for (Task task : tasks) {
            result.append("'" + task.getName() + "', ");
        }
        if (result.length() > 2) {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }

    public void assertExecutionEnded(String processInstanceId) {
        JbpmTestCase.assertNull((String)("Error: an active process instance with id " + processInstanceId + " was found"), (Object)executionService.findProcessInstanceById(processInstanceId));
    }

    public void assertProcessInstanceEnded(String processInstanceId) {
        this.assertExecutionEnded(processInstanceId);
    }

    public void assertProcessInstanceEnded(ProcessInstance processInstance) {
        this.assertExecutionEnded(processInstance.getId());
    }

    public void assertProcessInstanceActive(String processInstanceId) {
        JbpmTestCase.assertNotNull((String)("Error: an active process instance with id " + processInstanceId + " was not found"), (Object)executionService.findProcessInstanceById(processInstanceId));
    }

    public void assertActivityActive(String executionId, String activityName) {
        JbpmTestCase.assertTrue((String)("The execution with id '" + executionId + "' is not active in the activity '" + activityName + "'." + "Current activitites are: " + this.listAllActiveActivites(executionId)), (boolean)executionService.findExecutionById(executionId).isActive(activityName));
    }

    public void assertNotActivityActive(String executionId, String activityName) {
        Execution execution = executionService.findExecutionById(executionId);
        JbpmTestCase.assertFalse((boolean)execution.isActive(activityName));
    }

    public void assertActivitiesActive(String executionId, String ... activityNames) {
        for (String activityName : activityNames) {
            this.assertActivityActive(executionId, activityName);
        }
    }

    public void assertExecutionInOneOrMoreActivitiesActive(String executionId, String ... activityNames) {
        boolean inOneActivityActive = false;
        Execution execution = executionService.findExecutionById(executionId);
        for (String activityName : activityNames) {
            if (!execution.isActive(activityName)) continue;
            inOneActivityActive = true;
        }
        JbpmTestCase.assertTrue((String)("The execution with id '" + executionId + "' is not active in one of these activities: " + activityNames + "Current activitites are: " + this.listAllActiveActivites(executionId)), (boolean)inOneActivityActive);
    }

    protected String listAllActiveActivites(String executionId) {
        Execution execution = executionService.findExecutionById(executionId);
        Set activeActivities = execution.findActiveActivityNames();
        StringBuilder result = new StringBuilder();
        for (String activeActivity : activeActivities) {
            result.append("'" + activeActivity + "', ");
        }
        if (result.length() > 2) {
            result.setLength(result.length() - 2);
        }
        return result.toString();
    }
}

