/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.jbpm.api.ProcessEngine;
import org.jbpm.internal.log.Log;

public class Db {
    private static final Log log = Log.getLog((String)Db.class.getName());
    static Map<ProcessEngine, String[]> cleanSqlCache = new HashMap<ProcessEngine, String[]>();
    static Map<ProcessEngine, String[]> tableNamesCache = new HashMap<ProcessEngine, String[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clean(ProcessEngine processEngine) {
        SessionFactory sessionFactory = (SessionFactory)processEngine.get(SessionFactory.class);
        if (sessionFactory == null) {
            return;
        }
        String[] cleanSql = cleanSqlCache.get(processEngine);
        if (cleanSql == null) {
            Configuration configuration = (Configuration)processEngine.get(Configuration.class);
            SessionFactoryImplementor sessionFactoryImplementor = (SessionFactoryImplementor)sessionFactory;
            Dialect dialect = sessionFactoryImplementor.getDialect();
            ArrayList<String> dropForeignKeysSql = new ArrayList<String>();
            ArrayList<String> createForeignKeysSql = new ArrayList<String>();
            Iterator iter = configuration.getTableMappings();
            configuration.buildMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                String catalog = table.getCatalog();
                String schema = table.getSchema();
                Iterator subIter = table.getForeignKeyIterator();
                while (subIter.hasNext()) {
                    ForeignKey fk = (ForeignKey)subIter.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    dropForeignKeysSql.add(fk.sqlDropString(dialect, catalog, schema));
                    if (dialect instanceof MySQLDialect) {
                        dropForeignKeysSql.add("alter table " + table.getName() + " drop key " + fk.getName());
                    }
                    createForeignKeysSql.add(fk.sqlCreateString(dialect, (Mapping)sessionFactoryImplementor, catalog, schema));
                }
            }
            ArrayList<String> deleteSql = new ArrayList<String>();
            iter = configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                deleteSql.add("delete from " + table.getName());
            }
            ArrayList<String> cleanSqlList = new ArrayList<String>();
            cleanSqlList.addAll(dropForeignKeysSql);
            cleanSqlList.addAll(deleteSql);
            cleanSqlList.addAll(createForeignKeysSql);
            cleanSql = cleanSqlList.toArray(new String[cleanSqlList.size()]);
            cleanSqlCache.put(processEngine, cleanSql);
        }
        Session session = sessionFactory.openSession();
        try {
            for (String query : cleanSql) {
                session.createSQLQuery(query).executeUpdate();
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String verifyClean(ProcessEngine processEngine) {
        SessionFactory sessionFactory = (SessionFactory)processEngine.get(SessionFactory.class);
        if (sessionFactory == null) {
            return null;
        }
        String[] tableNames = tableNamesCache.get(processEngine);
        if (tableNames == null) {
            Configuration configuration = (Configuration)processEngine.get(Configuration.class);
            ArrayList<String> tableNamesList = new ArrayList<String>();
            Iterator iter = configuration.getTableMappings();
            while (iter.hasNext()) {
                Table table = (Table)iter.next();
                if (!table.isPhysicalTable()) continue;
                tableNamesList.add(table.getName());
            }
            tableNames = tableNamesList.toArray(new String[tableNamesList.size()]);
            tableNamesCache.put(processEngine, tableNames);
        }
        String recordsLeftMsg = "";
        Session session = sessionFactory.openSession();
        try {
            for (String tableName : tableNames) {
                if ("JBPM4_PROPERTY".equals(tableName)) continue;
                String countSql = "select count(*) as RECORD_COUNT_ from " + tableName;
                SQLQuery sqlQuery = session.createSQLQuery(countSql);
                sqlQuery.addScalar("RECORD_COUNT_", (Type)Hibernate.LONG);
                Long recordCount = (Long)sqlQuery.uniqueResult();
                if (recordCount <= 0L) continue;
                recordsLeftMsg = recordsLeftMsg + tableName + ":" + recordCount + ", ";
            }
        }
        finally {
            session.close();
        }
        if (recordsLeftMsg.length() > 0) {
            Db.clean(processEngine);
        }
        return recordsLeftMsg;
    }
}

