/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.io.IOException;
import org.jbpm.api.Configuration;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.HistoryService;
import org.jbpm.api.IdentityService;
import org.jbpm.api.ManagementService;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

public abstract class AbstractTransactionalSpringJbpmTestCase
extends AbstractTransactionalDataSourceSpringContextTests {
    private Configuration configuration;
    protected ProcessEngine processEngine;
    protected RepositoryService repositoryService;
    protected ExecutionService executionService;
    protected ManagementService managementService;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected IdentityService identityService;

    public AbstractTransactionalSpringJbpmTestCase() {
        this.setAutowireMode(1);
    }

    protected void injectDependencies() throws Exception {
        super.injectDependencies();
        this.configuration = (Configuration)this.applicationContext.getBean(this.getJbpmConfigurationName());
        this.processEngine = this.configuration.buildProcessEngine();
        this.repositoryService = (RepositoryService)this.processEngine.get(RepositoryService.class);
        this.executionService = this.processEngine.getExecutionService();
        this.historyService = this.processEngine.getHistoryService();
        this.managementService = this.processEngine.getManagementService();
        this.taskService = this.processEngine.getTaskService();
        this.identityService = this.processEngine.getIdentityService();
    }

    protected String getJbpmConfigurationName() {
        return "jbpmConfiguration";
    }

    public String deployJpdlXmlString(String jpdlXmlString) {
        String deploymentId = this.repositoryService.createDeployment().addResourceFromString("xmlstring.jpdl.xml", jpdlXmlString).deploy();
        return deploymentId;
    }

    public String deployJpdlFromClasspath(String jpdlXmlString) {
        String deploymentId;
        try {
            deploymentId = this.repositoryService.createDeployment().addResourceFromInputStream("xmlstring.jpdl.xml", new ClassPathResource(jpdlXmlString).getInputStream()).deploy();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return deploymentId;
    }
}

