/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.command;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.event.ProcessEventSupport;
import org.jbpm.casemgmt.api.CaseRuntimeDataService;
import org.jbpm.casemgmt.api.model.CaseDefinition;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.impl.command.CaseCommand;
import org.jbpm.casemgmt.impl.event.CaseEventSupport;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.services.api.ProcessService;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KieInternalServices;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.runtime.manager.context.CaseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReopenCaseCommand
extends CaseCommand<Void> {
    private static final long serialVersionUID = 6811181095390934146L;
    private static final Logger logger = LoggerFactory.getLogger(ReopenCaseCommand.class);
    private static CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();
    private String caseId;
    private String deploymentId;
    private String caseDefinitionId;
    private Map<String, Object> data;
    private transient ProcessService processService;
    private transient CaseRuntimeDataService caseRuntimeDataService;

    public ReopenCaseCommand(IdentityProvider identityProvider, String caseId, String deploymentId, String caseDefinitionId, Map<String, Object> data, ProcessService processService, CaseRuntimeDataService caseRuntimeDataService) {
        super(identityProvider);
        this.caseId = caseId;
        this.deploymentId = deploymentId;
        this.caseDefinitionId = caseDefinitionId;
        this.data = data;
        this.processService = processService;
        this.caseRuntimeDataService = caseRuntimeDataService;
    }

    public Void execute(org.kie.api.runtime.Context context) {
        CaseEventSupport caseEventSupport = this.getCaseEventSupport(context);
        KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
        CaseFileInstance caseFile = this.getCaseFile(ksession, this.caseId);
        caseEventSupport.fireBeforeCaseReopened(this.caseId, caseFile, this.deploymentId, this.caseDefinitionId, this.data);
        logger.debug("Updating case file in working memory");
        FactHandle factHandle = ksession.getFactHandle((Object)caseFile);
        ksession.update(factHandle, (Object)caseFile);
        logger.debug("Starting process instance for case {} and case definition {}", (Object)this.caseId, (Object)this.caseDefinitionId);
        CorrelationKey correlationKey = correlationKeyFactory.newCorrelationKey(this.caseId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CaseId", this.caseId);
        final Map caseData = caseFile.getData();
        caseEventSupport.fireAfterCaseDataAdded(caseFile.getCaseId(), caseFile, caseFile.getDefinitionId(), caseData);
        CaseDefinition definition = this.caseRuntimeDataService.getCase(this.deploymentId, this.caseDefinitionId);
        final Set varNames = definition.getProcessVariables();
        HashMap<String, Object> parameters = new HashMap<String, Object>(caseData);
        if (this.data != null) {
            parameters.putAll(this.data);
        }
        for (Map.Entry entry : parameters.entrySet()) {
            if (varNames.contains(entry.getKey())) {
                params.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            params.put("caseFile_" + (String)entry.getKey(), (String)entry.getValue());
        }
        final long processInstanceId = this.processService.startProcess(this.deploymentId, this.caseDefinitionId, correlationKey, params);
        ((CaseFileInstanceImpl)caseFile).setCaseReopenDate(new Date());
        if (this.data != null) {
            caseFile.addAll(this.data);
        }
        logger.debug("Removing case file from working memory to allow refiring of rules...");
        ksession.delete(factHandle);
        ksession.insert((Object)caseFile);
        if (!caseData.isEmpty()) {
            this.processService.execute(this.deploymentId, (Context)CaseContext.get((String)this.caseId), (Command)new ExecutableCommand<Void>(){
                private static final long serialVersionUID = -7093369406457484236L;

                public Void execute(org.kie.api.runtime.Context context) {
                    KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                    org.jbpm.process.instance.ProcessInstance pi = (org.jbpm.process.instance.ProcessInstance)ksession.getProcessInstance(processInstanceId);
                    if (pi != null) {
                        ProcessEventSupport processEventSupport = ((InternalProcessRuntime)((InternalKnowledgeRuntime)ksession).getProcessRuntime()).getProcessEventSupport();
                        VariableScope variableScope = (VariableScope)pi.getContextContainer().getDefaultContext("VariableScope");
                        for (Map.Entry entry : caseData.entrySet()) {
                            String name = varNames.contains(entry.getKey()) ? (String)entry.getKey() : "caseFile_" + (String)entry.getKey();
                            List tags = variableScope == null ? Collections.emptyList() : variableScope.tags(name);
                            processEventSupport.fireBeforeVariableChanged(name, name, null, entry.getValue(), tags, (ProcessInstance)pi, (KieRuntime)ksession);
                            processEventSupport.fireAfterVariableChanged(name, name, null, entry.getValue(), tags, (ProcessInstance)pi, (KieRuntime)ksession);
                        }
                    }
                    return null;
                }
            });
        }
        logger.debug("Case {} successfully reopened (process instance id {})", (Object)this.caseId, (Object)processInstanceId);
        caseEventSupport.fireAfterCaseReopened(this.caseId, caseFile, this.deploymentId, this.caseDefinitionId, this.data, processInstanceId);
        return null;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }
}

