/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.casemgmt.impl.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.casemgmt.api.audit.CaseFileData;
import org.jbpm.casemgmt.api.event.CaseDataEvent;
import org.jbpm.casemgmt.api.event.CaseEvent;
import org.jbpm.casemgmt.api.event.CaseEventListener;
import org.jbpm.casemgmt.api.event.CaseReopenEvent;
import org.jbpm.casemgmt.api.event.CaseRoleAssignmentEvent;
import org.jbpm.casemgmt.api.event.CaseStartEvent;
import org.jbpm.casemgmt.api.model.instance.CaseFileInstance;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.jbpm.casemgmt.impl.audit.CaseFileDataLog;
import org.jbpm.casemgmt.impl.audit.CaseIndexerManager;
import org.jbpm.casemgmt.impl.audit.CaseRoleAssignmentLog;
import org.jbpm.casemgmt.impl.model.instance.CaseFileInstanceImpl;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.MergeObjectCommand;
import org.jbpm.shared.services.impl.commands.PersistObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryStringCommand;
import org.jbpm.shared.services.impl.commands.UpdateStringCommand;
import org.kie.api.command.Command;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.internal.runtime.Cacheable;
import org.kie.internal.task.api.TaskModelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInstanceAuditEventListener
implements CaseEventListener,
Cacheable {
    private static final Logger logger = LoggerFactory.getLogger(CaseInstanceAuditEventListener.class);
    private TransactionalCommandService commandService;
    private CaseIndexerManager indexManager = CaseIndexerManager.get();

    public CaseInstanceAuditEventListener(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void afterCaseStarted(CaseStartEvent event) {
        CaseFileInstance caseFile = event.getCaseFile();
        if (caseFile == null) {
            return;
        }
        Collection<CaseRoleInstance> caseRoleAssignments = ((CaseFileInstanceImpl)caseFile).getAssignments();
        if (caseRoleAssignments != null && !caseRoleAssignments.isEmpty()) {
            for (CaseRoleInstance roleAssignment : caseRoleAssignments) {
                logger.debug("Role {} has following assignments {}", (Object)roleAssignment.getRoleName(), (Object)roleAssignment.getRoleAssignments());
                if (roleAssignment.getRoleAssignments() == null || roleAssignment.getRoleAssignments().isEmpty()) continue;
                ArrayList objects = new ArrayList();
                roleAssignment.getRoleAssignments().forEach(entity -> {
                    CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(event.getProcessInstanceId(), event.getCaseId(), roleAssignment.getRoleName(), (OrganizationalEntity)entity);
                    objects.add(assignmentLog);
                });
                this.commandService.execute((Command)new PersistObjectCommand(objects.toArray()));
            }
        } else {
            CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog(event.getProcessInstanceId(), event.getCaseId(), "*", (OrganizationalEntity)TaskModelProvider.getFactory().newGroup("_public_"));
            this.commandService.execute((Command)new PersistObjectCommand(new Object[]{assignmentLog}));
        }
        this.updateCaseFileItems((CaseEvent)event, event.getCaseFile().getData(), event.getCaseId(), event.getCaseDefinitionId(), event.getUser());
    }

    public void afterCaseReopen(CaseReopenEvent event) {
        logger.debug("Updating process instance id ({})in case assignment log for case id {}", (Object)event.getProcessInstanceId(), (Object)event.getCaseId());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("piID", event.getProcessInstanceId());
        parameters.put("caseId", event.getCaseId());
        UpdateStringCommand updateCommand = new UpdateStringCommand("update CaseRoleAssignmentLog set processInstanceId =:piID where caseId =:caseId", parameters);
        int updated = (Integer)this.commandService.execute((Command)updateCommand);
        logger.debug("Updated {} role assignment entries for case id {}", (Object)updated, (Object)event.getCaseId());
        this.updateCaseFileItems((CaseEvent)event, event.getData(), event.getCaseId(), event.getCaseDefinitionId(), event.getUser());
    }

    public void afterCaseRoleAssignmentAdded(CaseRoleAssignmentEvent event) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", event.getCaseId());
        QueryStringCommand queryCommand = new QueryStringCommand("select processInstanceId from ProcessInstanceLog where correlationKey =:caseId", parameters);
        List processInstanceId = (List)this.commandService.execute((Command)queryCommand);
        if (processInstanceId.isEmpty()) {
            return;
        }
        CaseRoleAssignmentLog assignmentLog = new CaseRoleAssignmentLog((Long)processInstanceId.get(0), event.getCaseId(), event.getRole(), event.getEntity());
        this.commandService.execute((Command)new PersistObjectCommand(new Object[]{assignmentLog}));
    }

    public void afterCaseRoleAssignmentRemoved(CaseRoleAssignmentEvent event) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", event.getCaseId());
        parameters.put("role", event.getRole());
        parameters.put("entity", event.getEntity().getId());
        UpdateStringCommand updateCommand = new UpdateStringCommand("delete from CaseRoleAssignmentLog where caseId =:caseId and roleName =:role and entityId =:entity", parameters);
        this.commandService.execute((Command)updateCommand);
        logger.debug("Removed {} role assignment for entity {} for case id {}", new Object[]{event.getRole(), event.getEntity(), event.getCaseId()});
    }

    public void afterCaseDataAdded(CaseDataEvent event) {
        this.updateCaseFileItems((CaseEvent)event, event.getData(), event.getCaseId(), event.getDefinitionId(), event.getUser());
    }

    public void afterCaseDataRemoved(CaseDataEvent event) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry entry : event.getData().entrySet()) {
            List<String> indexedNames = this.indexManager.getIndexNames((String)entry.getKey(), entry.getValue());
            if (indexedNames == null) continue;
            names.addAll(indexedNames);
        }
        parameters.put("caseId", event.getCaseId());
        parameters.put("itemNames", names);
        UpdateStringCommand updateCommand = new UpdateStringCommand("delete from CaseFileDataLog where caseId =:caseId and itemName in (:itemNames)", parameters);
        this.commandService.execute((Command)updateCommand);
    }

    public void close() {
    }

    protected List<String> currentCaseData(String caseId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", caseId);
        QueryStringCommand queryCommand = new QueryStringCommand("select itemName from CaseFileDataLog where caseId =:caseId", parameters);
        List caseDataLog = (List)this.commandService.execute((Command)queryCommand);
        return caseDataLog;
    }

    protected CaseFileDataLog caseFileDataByName(String caseId, String name) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseId", caseId);
        parameters.put("itemName", name);
        QueryStringCommand queryCommand = new QueryStringCommand("select cfdl from CaseFileDataLog cfdl where cfdl.caseId =:caseId and cfdl.itemName =:itemName", parameters);
        List caseDataLog = (List)this.commandService.execute((Command)queryCommand);
        return (CaseFileDataLog)caseDataLog.get(0);
    }

    protected void updateCaseFileItems(CaseEvent event, Map<String, Object> addedData, String caseId, String caseDefinitionId, String user) {
        if (addedData.isEmpty()) {
            return;
        }
        ArrayList insert = new ArrayList();
        ArrayList update = new ArrayList();
        List<String> currentCaseData = this.currentCaseData(caseId);
        addedData.forEach((name, value) -> {
            if (value != null) {
                List<CaseFileData> indexedValues = this.indexManager.index(event, (String)name, value);
                for (CaseFileData item : indexedValues) {
                    CaseFileDataLog caseFileDataLog = null;
                    if (currentCaseData.contains(item.getItemName())) {
                        logger.debug("Case instance {} has already stored log value for {} thus it's going to be updated", (Object)caseId, (Object)item.getItemName());
                        caseFileDataLog = this.caseFileDataByName(caseId, item.getItemName());
                        update.add(caseFileDataLog);
                    } else {
                        logger.debug("Case instance {} has no log value for {} thus it's going to be inserted", (Object)caseId, (Object)item.getItemName());
                        caseFileDataLog = new CaseFileDataLog(caseId, caseDefinitionId, item.getItemName());
                        insert.add(caseFileDataLog);
                    }
                    caseFileDataLog.setItemType(item.getItemType());
                    caseFileDataLog.setItemValue(item.getItemValue());
                    caseFileDataLog.setLastModified(item.getLastModified());
                    caseFileDataLog.setLastModifiedBy(item.getLastModifiedBy());
                }
            }
        });
        this.commandService.execute((Command)new PersistObjectCommand(insert.toArray()));
        this.commandService.execute((Command)new MergeObjectCommand(update.toArray()));
    }
}

