/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.I18NTextImpl;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.PeopleAssignments;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskData;

public class TaskFluent {
    private TaskImpl task;
    private PeopleAssignmentsImpl assignments;
    private List<I18NText> names;
    private List<I18NText> descriptions;
    private List<I18NText> subjects;

    public TaskFluent() {
        if (this.task == null) {
            this.task = new TaskImpl();
            this.task.setTaskData((TaskData)new TaskDataImpl());
            this.assignments = new PeopleAssignmentsImpl();
            this.task.setPeopleAssignments((PeopleAssignments)this.assignments);
            this.names = new ArrayList<I18NText>();
            this.task.setNames(this.names);
            this.descriptions = new ArrayList<I18NText>();
            this.task.setDescriptions(this.descriptions);
            this.subjects = new ArrayList<I18NText>();
            this.task.setSubjects(this.subjects);
        }
    }

    public Task getTask() {
        if (((TaskDataImpl)this.task.getTaskData()).getCreatedOn() == null) {
            ((TaskDataImpl)this.task.getTaskData()).setCreatedOn(new Date());
        }
        return this.task;
    }

    public TaskFluent setName(String name) {
        this.task.setName(name);
        return this;
    }

    public TaskFluent setDescription(String description) {
        this.task.setDescription(description);
        return this;
    }

    public TaskFluent setSubject(String subject) {
        this.task.setSubject(subject);
        return this;
    }

    public TaskFluent setWorkItemId(long workItemId) {
        ((TaskDataImpl)this.task.getTaskData()).setWorkItemId(workItemId);
        return this;
    }

    public TaskFluent setWorkItemId(String deploymentId) {
        ((TaskDataImpl)this.task.getTaskData()).setDeploymentId(deploymentId);
        return this;
    }

    public TaskFluent setProcessId(String processId) {
        ((TaskDataImpl)this.task.getTaskData()).setProcessId(processId);
        return this;
    }

    public TaskFluent setProcessInstanceId(long processInstanceId) {
        ((TaskDataImpl)this.task.getTaskData()).setProcessInstanceId(processInstanceId);
        return this;
    }

    public TaskFluent setProcessSessionId(int processSessionId) {
        ((TaskDataImpl)this.task.getTaskData()).setProcessSessionId(processSessionId);
        return this;
    }

    public TaskFluent setParentId(long parentId) {
        ((TaskDataImpl)this.task.getTaskData()).setParentId(parentId);
        return this;
    }

    public TaskFluent setCreatedBy(String userId) {
        ((TaskDataImpl)this.task.getTaskData()).setCreatedBy(new UserImpl(userId));
        return this;
    }

    public TaskFluent setCreatedOn(Date createdOn) {
        ((TaskDataImpl)this.task.getTaskData()).setCreatedOn(createdOn);
        return this;
    }

    public TaskFluent setDueDate(Date dueDate) {
        ((TaskDataImpl)this.task.getTaskData()).setExpirationTime(dueDate);
        return this;
    }

    public TaskFluent addI18NName(String language, String name) {
        this.task.getNames().add((I18NText)new I18NTextImpl(language, name));
        return this;
    }

    public TaskFluent addI18NDescription(String language, String description) {
        this.task.getDescriptions().add((I18NText)new I18NTextImpl(language, description));
        return this;
    }

    public TaskFluent addI18NSubject(String language, String subject) {
        this.task.getSubjects().add((I18NText)new I18NTextImpl(language, subject));
        return this;
    }

    public TaskFluent setPriority(int priority) {
        this.task.setPriority(priority);
        return this;
    }

    public TaskFluent addPotentialUser(String userId) {
        if (this.assignments.getPotentialOwners().isEmpty()) {
            ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>();
            this.assignments.setPotentialOwners(potentialOwners);
        }
        this.assignments.getPotentialOwners().add((OrganizationalEntity)new UserImpl(userId));
        return this;
    }

    public TaskFluent addPotentialGroup(String groupId) {
        if (this.assignments.getPotentialOwners().isEmpty()) {
            ArrayList<OrganizationalEntity> potentialOwners = new ArrayList<OrganizationalEntity>();
            this.assignments.setPotentialOwners(potentialOwners);
        }
        this.assignments.getPotentialOwners().add((OrganizationalEntity)new GroupImpl(groupId));
        return this;
    }

    public TaskFluent setAdminUser(String userId) {
        if (this.assignments.getBusinessAdministrators().isEmpty()) {
            ArrayList<OrganizationalEntity> businessAdmins = new ArrayList<OrganizationalEntity>();
            this.assignments.setBusinessAdministrators(businessAdmins);
        }
        this.assignments.getBusinessAdministrators().add((OrganizationalEntity)new UserImpl(userId));
        return this;
    }

    public TaskFluent setAdminGroup(String groupId) {
        if (this.assignments.getBusinessAdministrators().isEmpty()) {
            ArrayList<OrganizationalEntity> businessAdmins = new ArrayList<OrganizationalEntity>();
            this.assignments.setBusinessAdministrators(businessAdmins);
        }
        this.assignments.getBusinessAdministrators().add((OrganizationalEntity)new GroupImpl(groupId));
        return this;
    }

    public TaskFluent setFormName(String formName) {
        this.task.setFormName(formName);
        return this;
    }

    public TaskFluent setDeploymentID(String deploymentId) {
        ((TaskDataImpl)this.task.getTaskData()).setDeploymentId(deploymentId);
        return this;
    }
}

