/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.prediction;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kie.internal.task.api.prediction.PredictionService;

public class PredictionServiceRegistry {
    private static final ServiceLoader<PredictionService> foundServices = ServiceLoader.load(PredictionService.class, PredictionServiceRegistry.class.getClassLoader());
    private static final String selectedService = System.getProperty("org.jbpm.task.prediction.service", "NoOp");
    private static final Map<String, PredictionService> predictionServices = new HashMap<String, PredictionService>();

    private PredictionServiceRegistry() {
        foundServices.forEach(strategy -> predictionServices.put(strategy.getIdentifier(), (PredictionService)strategy));
    }

    public static PredictionServiceRegistry get() {
        return Holder.INSTANCE;
    }

    public PredictionService getService() {
        PredictionService predictionService = predictionServices.get(selectedService);
        if (predictionService == null) {
            throw new IllegalArgumentException("No prediction service was found with id " + selectedService);
        }
        return predictionService;
    }

    public synchronized void addStrategy(PredictionService predictionService) {
        predictionServices.put(predictionService.getIdentifier(), predictionService);
    }

    private static class Holder {
        static final PredictionServiceRegistry INSTANCE = new PredictionServiceRegistry();

        private Holder() {
        }
    }
}

