/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.identity;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.jbpm.services.task.identity.AbstractLDAPUserGroupInfo;
import org.jbpm.services.task.utils.LdapSearcher;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.UserInfo;

public class LDAPUserInfoImpl
extends AbstractLDAPUserGroupInfo
implements UserInfo {
    private static final String DEFAULT_PROPERTIES_NAME = "jbpm.user.info";
    public static final String USER_CTX = "ldap.user.ctx";
    public static final String ROLE_CTX = "ldap.role.ctx";
    public static final String USER_FILTER = "ldap.user.filter";
    public static final String ROLE_FILTER = "ldap.role.filter";
    public static final String ROLE_MEMBERS_FILTER = "ldap.role.members.filter";
    public static final String EMAIL_FILTER = "ldap.email.filter";
    public static final String EMAIL_ATTR_ID = "ldap.email.attr.id";
    public static final String NAME_ATTR_ID = "ldap.name.attr.id";
    public static final String LANG_ATTR_ID = "ldap.lang.attr.id";
    public static final String MEMBER_ATTR_ID = "ldap.member.attr.id";
    public static final String USER_ATTR_ID = "ldap.user.attr.id";
    public static final String ROLE_ATTR_ID = "ldap.role.attr.id";
    public static final String IS_ENTITY_ID_DN = "ldap.entity.id.dn";
    public static final String SEARCH_SCOPE = "ldap.search.scope";
    private static final String[] REQUIRED_PROPERTIES = new String[]{"ldap.user.ctx", "ldap.role.ctx", "ldap.user.filter", "ldap.role.filter"};
    private static final String DEFAULT_EMAIL_ATTR_ID = "mail";
    private static final String DEFAULT_ENTITY_ID_DN = "false";
    private static final String DEFAULT_LANG_ATTR_ID = "locale";
    private static final String DEFAULT_MEMBER_ATTR_ID = "member";
    private static final String DEFAULT_NAME_ATTR_ID = "displayName";
    private static final String DEFAULT_LOCALE = "en-UK";

    public LDAPUserInfoImpl(boolean activate) {
        super(REQUIRED_PROPERTIES, DEFAULT_PROPERTIES_NAME);
    }

    public LDAPUserInfoImpl(Properties config) {
        super(REQUIRED_PROPERTIES, config);
    }

    public String getDisplayName(OrganizationalEntity entity) {
        return this.getAttributeValueForEntity(entity, NAME_ATTR_ID, DEFAULT_NAME_ATTR_ID);
    }

    public Iterator<OrganizationalEntity> getMembersForGroup(Group group) {
        String roleContext = this.getConfigProperty(ROLE_CTX);
        String roleFilter = this.getConfigProperty(ROLE_MEMBERS_FILTER, this.getConfigProperty(ROLE_FILTER));
        String roleAttrId = this.getConfigProperty(MEMBER_ATTR_ID, DEFAULT_MEMBER_ATTR_ID);
        String entityId = this.extractEntityId((OrganizationalEntity)group);
        List<String> memberIds = this.ldapSearcher.search(roleContext, roleFilter, entityId).getAttributeResults(roleAttrId);
        return memberIds.stream().filter(memberId -> memberId != null).map(memberId -> TaskModelProvider.getFactory().newUser(memberId)).collect(Collectors.toList()).iterator();
    }

    public boolean hasEmail(Group group) {
        return this.getEmailForEntity((OrganizationalEntity)group) != null;
    }

    public String getEmailForEntity(OrganizationalEntity entity) {
        return this.getAttributeValueForEntity(entity, EMAIL_ATTR_ID, DEFAULT_EMAIL_ATTR_ID);
    }

    public String getLanguageForEntity(OrganizationalEntity entity) {
        String result = this.getAttributeValueForEntity(entity, LANG_ATTR_ID, DEFAULT_LANG_ATTR_ID);
        return result == null ? DEFAULT_LOCALE : result;
    }

    private String getAttributeValueForEntity(OrganizationalEntity entity, String attributeName, String defaultValue) {
        String context = this.getConfigPropertyByEntity(entity, USER_CTX, ROLE_CTX);
        String filter = this.getConfigPropertyByEntity(entity, USER_FILTER, ROLE_FILTER);
        String attrId = this.getConfigProperty(attributeName, defaultValue);
        String entityId = this.extractEntityId(entity);
        return this.ldapSearcher.search(context, filter, entityId).getSingleAttributeResult(attrId);
    }

    private String getConfigPropertyByEntity(OrganizationalEntity entity, String userKey, String roleKey) {
        if (entity instanceof User) {
            return this.getConfigProperty(userKey);
        }
        if (entity instanceof Group) {
            return this.getConfigProperty(roleKey);
        }
        throw new IllegalArgumentException("Unknown organizational entity: " + entity);
    }

    private String extractEntityId(OrganizationalEntity entity) {
        if (!this.isEntityIdDn()) {
            return entity.getId();
        }
        String entityAttrId = null;
        if (entity instanceof User) {
            entityAttrId = this.getConfigProperty(USER_ATTR_ID, "uid");
        } else if (entity instanceof Group) {
            entityAttrId = this.getConfigProperty(ROLE_ATTR_ID, "cn");
        }
        return this.extractAttribute(entity.getId(), entityAttrId);
    }

    private String extractAttribute(String entityId, String entityAttrId) {
        String entityDN = entityId;
        String[] attributes = entityDN.split(",");
        if (attributes.length == 1) {
            return entityDN;
        }
        for (String attribute : attributes) {
            String[] keyValue = attribute.split("=");
            if (!keyValue[0].equalsIgnoreCase(entityAttrId)) continue;
            return keyValue[1];
        }
        throw new RuntimeException("Cannot parse '" + entityAttrId + "' attribute from entity DN '" + entityDN + "'");
    }

    private boolean isEntityIdDn() {
        return Boolean.parseBoolean(this.getConfigProperty(IS_ENTITY_ID_DN, DEFAULT_ENTITY_ID_DN));
    }

    public String getEntityForEmail(String email) {
        String context = this.getConfigProperty(USER_CTX);
        String filter = this.getConfigProperty(EMAIL_FILTER);
        String attributeId = this.getConfigProperty(USER_ATTR_ID, "uid");
        LdapSearcher.LdapResults searcher = this.ldapSearcher.search(context, filter, email);
        if (searcher.getSearchResults().isEmpty()) {
            return null;
        }
        if (this.isEntityIdDn()) {
            return searcher.getSingleSearchResult().getNameInNamespace();
        }
        return searcher.getSingleAttributeResult(attributeId);
    }
}

