/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.commands;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jbpm.services.task.commands.TaskContext;
import org.jbpm.services.task.commands.UserGroupCallbackTaskCommand;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.impl.model.xml.JaxbAttachment;
import org.jbpm.services.task.impl.model.xml.JaxbContent;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Context;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalAttachment;
import org.kie.internal.task.api.model.InternalContent;

@XmlRootElement(name="add-attachment-command")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AddAttachmentCommand
extends UserGroupCallbackTaskCommand<Long> {
    private static final long serialVersionUID = -1295175842745522756L;
    @XmlElement
    private JaxbAttachment jaxbAttachment;
    @XmlTransient
    private Attachment attachment;
    @XmlElement
    private JaxbContent jaxbContent;
    @XmlTransient
    private Content content;
    @XmlTransient
    private Object rawContent;

    public AddAttachmentCommand() {
    }

    public AddAttachmentCommand(Long taskId, Attachment attachment, Content content) {
        this.taskId = taskId;
        this.setAttachment(attachment);
        this.setContent(content);
    }

    public AddAttachmentCommand(Long taskId, Attachment attachment, Object rawContent) {
        this.taskId = taskId;
        this.setAttachment(attachment);
        this.setRawContent(rawContent);
    }

    @Override
    public Long execute(Context cntxt) {
        Content contentImpl;
        TaskContext context = (TaskContext)cntxt;
        Attachment attachmentImpl = this.attachment;
        if (attachmentImpl == null) {
            attachmentImpl = this.jaxbAttachment;
        }
        if ((contentImpl = this.content) == null) {
            contentImpl = this.jaxbContent;
        }
        if (this.rawContent != null && contentImpl == null) {
            Task task = context.getPersistenceContext().findTask(this.taskId);
            contentImpl = TaskModelProvider.getFactory().newContent();
            ContentMarshallerContext ctx = TaskContentRegistry.get().getMarshallerContext(task.getTaskData().getDeploymentId());
            ((InternalContent)contentImpl).setContent(ContentMarshallerHelper.marshallContent(task, this.rawContent, ctx.getEnvironment()));
            ((InternalAttachment)attachmentImpl).setSize(contentImpl.getContent().length);
        }
        this.doCallbackOperationForAttachment(attachmentImpl, context);
        return context.getTaskAttachmentService().addAttachment(this.taskId.longValue(), attachmentImpl, contentImpl);
    }

    public void setAttachment(Attachment attachment) {
        this.attachment = attachment;
        this.jaxbAttachment = attachment instanceof JaxbAttachment ? (JaxbAttachment)attachment : new JaxbAttachment(attachment);
    }

    public JaxbAttachment getJaxbAttachment() {
        return this.jaxbAttachment;
    }

    public void setJaxbAttachment(JaxbAttachment jaxbAttachment) {
        this.jaxbAttachment = jaxbAttachment;
    }

    public JaxbContent getJaxbContent() {
        return this.jaxbContent;
    }

    public void setJaxbContent(JaxbContent jaxbContent) {
        this.jaxbContent = jaxbContent;
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
        this.jaxbContent = content instanceof JaxbContent ? (JaxbContent)content : new JaxbContent(content);
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    public Object getRawContent() {
        return this.rawContent;
    }

    public void setRawContent(Object rawContent) {
        this.rawContent = rawContent;
    }
}

