/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleunit.impl;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.util.ClassUtils;
import org.drools.ruleunit.DataSource;
import org.drools.ruleunit.RuleUnit;
import org.drools.ruleunit.UnitVar;
import org.drools.ruleunit.datasources.InternalDataSource;
import org.drools.ruleunit.executor.InternalRuleUnitExecutor;

public class RuleUnitFactory {
    private Map<RuleUnit.Identity, RuleUnit> units = new HashMap<RuleUnit.Identity, RuleUnit>();
    private Map<String, Object> variables = new HashMap<String, Object>();

    public RuleUnitFactory bindVariable(String name, Object dataSource) {
        this.variables.put(name, dataSource);
        return this;
    }

    public RuleUnit getOrCreateRuleUnit(InternalRuleUnitExecutor executor, String name, ClassLoader classLoader) {
        try {
            return this.getOrCreateRuleUnit(executor, Class.forName(name, true, classLoader));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find RuleUnit class " + name, e);
        }
    }

    public <T extends RuleUnit> T getOrCreateRuleUnit(InternalRuleUnitExecutor executor, Class<T> ruleUnitClass) {
        return (T)this.units.computeIfAbsent(new RuleUnit.Identity(ruleUnitClass, new Object[0]), id -> this.createRuleUnit(executor, ruleUnitClass));
    }

    public RuleUnit registerUnit(InternalRuleUnitExecutor executor, RuleUnit ruleUnit) {
        return this.units.computeIfAbsent(ruleUnit.getUnitIdentity(), id -> this.injectUnitVariables(executor, ruleUnit));
    }

    private <T extends RuleUnit> T createRuleUnit(InternalRuleUnitExecutor executor, Class<T> ruleUnitClass) {
        try {
            return (T)this.injectUnitVariables(executor, ruleUnitClass, (RuleUnit)ruleUnitClass.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instance RuleUnit " + ruleUnitClass.getName(), e);
        }
    }

    public <T extends RuleUnit> T injectUnitVariables(InternalRuleUnitExecutor executor, T ruleUnit) {
        return (T)this.injectUnitVariables(executor, ruleUnit.getClass(), ruleUnit);
    }

    private <T extends RuleUnit> T injectUnitVariables(InternalRuleUnitExecutor executor, Class<T> ruleUnitClass, T ruleUnit) {
        for (Field field : ruleUnitClass.getDeclaredFields()) {
            Object existingValue;
            String fieldName = this.getInjectingName(field);
            Object var = this.variables.get(this.getInjectingName(field));
            if (ClassUtils.isAssignable(field.getType(), (Object)var)) {
                existingValue = this.readFieldValue(field, ruleUnit);
                if (existingValue != null && (!(existingValue instanceof Number) || ((Number)existingValue).intValue() != 0)) continue;
                try {
                    field.set(ruleUnit, var);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Unable to inject field " + fieldName + " into " + ruleUnitClass.getName(), e);
                }
            }
            if (var != null || !DataSource.class.isAssignableFrom(field.getType()) || !((existingValue = this.readFieldValue(field, ruleUnit)) instanceof InternalDataSource)) continue;
            executor.bindDataSource((InternalDataSource)existingValue);
        }
        return ruleUnit;
    }

    private Object readFieldValue(Field field, Object obj) {
        field.setAccessible(true);
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to read field " + field.getName() + " from " + obj, e);
        }
    }

    private String getInjectingName(Field field) {
        UnitVar varName = field.getAnnotation(UnitVar.class);
        return varName != null ? varName.value() : field.getName();
    }
}

