/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.query.preprocessor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.jbpm.kie.services.impl.query.preprocessor.UserTasksPreprocessor;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.identity.IdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAndGroupsTasksPreprocessor
extends UserTasksPreprocessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAndGroupsTasksPreprocessor.class);
    private IdentityProvider identityProvider;
    private UserGroupCallback userGroupCallback;
    private String columnId;

    public UserAndGroupsTasksPreprocessor(IdentityProvider identityProvider, UserGroupCallback userGroupCallback, String columnId, DataSetMetadata metadata) {
        super(metadata);
        this.identityProvider = identityProvider;
        this.userGroupCallback = userGroupCallback;
        this.columnId = columnId;
    }

    @Override
    public void preprocess(DataSetLookup lookup) {
        ColumnFilter columnFilter;
        if (this.identityProvider == null || this.userGroupCallback == null) {
            return;
        }
        ArrayList<Comparable> orgEntities = new ArrayList<Comparable>();
        if (lookup.getFirstFilterOp() != null) {
            ArrayList potOwners = new ArrayList();
            List<CoreFunctionFilter> columnFilters = this.extractCoreFunctionFilter(lookup.getFirstFilterOp().getColumnFilterList());
            Iterator<CoreFunctionFilter> it = columnFilters.iterator();
            while (orgEntities.isEmpty() && it.hasNext()) {
                CoreFunctionFilter column = it.next();
                if (!column.getColumnId().toUpperCase().equals(this.columnId)) continue;
                potOwners.addAll(column.getParameters());
                for (String potOwner : potOwners) {
                    this.addUserAndGroupsFromIdentityProvider(orgEntities, potOwner);
                }
                this.removeCoreFunctionFilter(lookup.getFirstFilterOp().getColumnFilterList(), (ColumnFilter)column);
            }
            if (orgEntities.isEmpty()) {
                this.addUserAndGroupsFromIdentityProvider(orgEntities, this.identityProvider.getName());
            }
            columnFilter = FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.in((String)"POTOWNER", orgEntities)});
            lookup.getFirstFilterOp().addFilterColumn(new ColumnFilter[]{columnFilter});
        } else {
            DataSetFilter filter = new DataSetFilter();
            this.addUserAndGroupsFromIdentityProvider(orgEntities, this.identityProvider.getName());
            columnFilter = FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.in((String)"POTOWNER", orgEntities)});
            filter.addFilterColumn(new ColumnFilter[]{columnFilter});
            lookup.addOperation(new DataSetOp[]{filter});
        }
        LOGGER.debug("Adding column filter: {}", (Object)columnFilter);
        super.preprocess(lookup);
    }

    private void addUserAndGroupsFromIdentityProvider(List<Comparable> orgEntities, String userId) {
        orgEntities.addAll(Optional.ofNullable(this.userGroupCallback.getGroupsForUser(userId)).orElse(new ArrayList()));
        orgEntities.add((Comparable)((Object)userId));
    }

    private void removeCoreFunctionFilter(List<ColumnFilter> filters, ColumnFilter removedFilter) {
        if (filters.remove(removedFilter)) {
            return;
        }
        filters.stream().filter(e -> e instanceof LogicalExprFilter).map(e -> (LogicalExprFilter)e).forEach(filter -> this.removeCoreFunctionFilter(filter.getLogicalTerms(), removedFilter));
    }

    private List<CoreFunctionFilter> extractCoreFunctionFilter(List<ColumnFilter> filters) {
        ArrayList<CoreFunctionFilter> list = new ArrayList<CoreFunctionFilter>();
        for (ColumnFilter filter : filters) {
            if (filter instanceof CoreFunctionFilter) {
                list.add((CoreFunctionFilter)filter);
                continue;
            }
            if (!(filter instanceof LogicalExprFilter)) continue;
            list.addAll(this.extractCoreFunctionFilter(((LogicalExprFilter)filter).getLogicalTerms()));
        }
        return list;
    }
}

