/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.info;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.drools.persistence.api.PersistentSession;
import org.drools.persistence.api.SessionMarshallingHelper;

@Entity
@SequenceGenerator(name="sessionInfoIdSeq", sequenceName="SESSIONINFO_ID_SEQ")
public class SessionInfo
implements PersistentSession {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="sessionInfoIdSeq")
    private Long id;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    private Date startDate = new Date();
    private Date lastModificationDate;
    @Lob
    @Column(length=0x7FFFFFFF)
    private byte[] rulesByteArray;
    @Transient
    SessionMarshallingHelper helper;

    public Long getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setJPASessionMashallingHelper(SessionMarshallingHelper helper) {
        this.helper = helper;
    }

    public SessionMarshallingHelper getJPASessionMashallingHelper() {
        return this.helper;
    }

    public void setData(byte[] data) {
        this.rulesByteArray = data;
    }

    public byte[] getData() {
        return this.rulesByteArray;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(Date date) {
        this.lastModificationDate = date;
    }

    public void transform() {
        this.rulesByteArray = this.helper.getSnapshot();
    }

    public void setId(Long ksessionId) {
        this.id = ksessionId;
    }
}

