/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.api.integration.model;

import java.util.Date;
import org.jbpm.persistence.api.integration.InstanceView;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.internal.task.api.model.TaskEvent;

public class TaskOperationView
implements InstanceView<TaskEvent> {
    private static final long serialVersionUID = 1L;
    private transient TaskEvent source;
    private String compositeId;
    private TaskEvent.TaskEventType type;
    private TaskLifeCycleEventListener.AssignmentType assignType;
    private Date date;
    private String userId;

    public TaskOperationView(TaskEvent taskEvent, TaskEvent.TaskEventType type, TaskLifeCycleEventListener.AssignmentType assignType) {
        this.source = taskEvent;
        this.type = type;
        this.assignType = assignType;
    }

    public TaskEvent.TaskEventType getType() {
        return this.type;
    }

    public TaskLifeCycleEventListener.AssignmentType getAssignType() {
        return this.assignType;
    }

    public String getUserId() {
        return this.userId;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public void copyFromSource() {
        this.compositeId = System.getProperty("org.kie.server.id", "") + '_' + this.source.getTask().getId();
        this.userId = this.source.getTaskContext().getUserId();
        this.date = this.source.getEventDate();
    }

    @Override
    public TaskEvent getSource() {
        return this.source;
    }

    @Override
    public String getCompositeId() {
        return this.compositeId;
    }

    public String toString() {
        return "TaskOperationView [compositeId=" + this.compositeId + ", type=" + this.type + ", assignType=" + this.assignType + ", date=" + this.date + ", userId=" + this.userId + "]";
    }
}

