/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4.misc;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.antlr.runtime.misc.DoubleKeyMap;
import org.stringtemplate.v4.Interpreter;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.misc.Misc;
import org.stringtemplate.v4.misc.STNoSuchPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectModelAdaptor
implements ModelAdaptor {
    protected DoubleKeyMap<Class<?>, String, Member> classAndPropertyToMemberCache = new DoubleKeyMap();

    @Override
    public synchronized Object getProperty(Interpreter interp, ST self, Object o, Object property, String propertyName) throws STNoSuchPropertyException {
        Object value = null;
        Class<?> c = o.getClass();
        if (property == null) {
            return this.throwNoSuchProperty(c, propertyName, null);
        }
        Member member = (Member)this.classAndPropertyToMemberCache.get(c, (Object)propertyName);
        if (member != null) {
            try {
                Class<?> memberClass = member.getClass();
                if (memberClass == Method.class) {
                    return ((Method)member).invoke(o, new Object[0]);
                }
                if (memberClass == Field.class) {
                    return ((Field)member).get(o);
                }
            }
            catch (Exception e) {
                this.throwNoSuchProperty(c, propertyName, e);
            }
        }
        return this.lookupMethod(o, propertyName, value, c);
    }

    public synchronized Object lookupMethod(Object o, String propertyName, Object value, Class<?> c) {
        String methodSuffix = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1, propertyName.length());
        Method m = Misc.getMethod(c, "get" + methodSuffix);
        if (m == null && (m = Misc.getMethod(c, "is" + methodSuffix)) == null) {
            m = Misc.getMethod(c, "has" + methodSuffix);
        }
        try {
            if (m != null) {
                this.classAndPropertyToMemberCache.put(c, (Object)propertyName, (Object)m);
                value = Misc.invokeMethod(m, o, value);
            } else {
                Field f = c.getField(propertyName);
                this.classAndPropertyToMemberCache.put(c, (Object)propertyName, (Object)f);
                try {
                    value = Misc.accessField(f, o, value);
                }
                catch (IllegalAccessException iae) {
                    this.throwNoSuchProperty(c, propertyName, iae);
                }
            }
        }
        catch (Exception e) {
            this.throwNoSuchProperty(c, propertyName, e);
        }
        return value;
    }

    protected Object throwNoSuchProperty(Class<?> clazz, String propertyName, Exception cause) {
        throw new STNoSuchPropertyException(cause, null, clazz.getName() + "." + propertyName);
    }
}

