/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshallerExt;
import org.dashbuilder.json.JsonObject;

public class SQLDefJSONMarshaller
implements DataSetDefJSONMarshallerExt<SQLDataSetDef> {
    public static SQLDefJSONMarshaller INSTANCE = new SQLDefJSONMarshaller();
    public static final String DATA_SOURCE = "dataSource";
    public static final String DB_SCHEMA = "dbSchema";
    public static final String DB_TABLE = "dbTable";
    public static final String DB_SQL = "dbSQL";

    @Override
    public void fromJson(SQLDataSetDef def, JsonObject json) {
        String dataSource = json.getString(DATA_SOURCE);
        String dbTable = json.getString(DB_TABLE);
        String dbSchema = json.getString(DB_SCHEMA);
        String dbSQL = json.getString(DB_SQL);
        if (!DataSetDefJSONMarshaller.isBlank(dataSource)) {
            def.setDataSource(dataSource);
        }
        if (!DataSetDefJSONMarshaller.isBlank(dbSchema)) {
            def.setDbSchema(dbSchema);
        }
        if (!DataSetDefJSONMarshaller.isBlank(dbTable)) {
            def.setDbTable(dbTable);
        }
        if (!DataSetDefJSONMarshaller.isBlank(dbSQL)) {
            def.setDbSQL(dbSQL);
        }
    }

    @Override
    public void toJson(SQLDataSetDef dataSetDef, JsonObject json) {
        json.put(DATA_SOURCE, dataSetDef.getDataSource());
        json.put(DB_SCHEMA, dataSetDef.getDbSchema());
        if (dataSetDef.getDbTable() != null) {
            json.put(DB_TABLE, dataSetDef.getDbTable());
        }
        if (dataSetDef.getDbSQL() != null) {
            json.put(DB_SQL, dataSetDef.getDbSQL());
        }
        json.put("allColumns", dataSetDef.isAllColumnsEnabled());
    }
}

