/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.json.Json;
import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonValue;

public class DataSetMetadataJSONMarshaller {
    public static final String UUID = "uuid";
    public static final String NUMBER_OF_ROWS = "numberOfRows";
    public static final String NUMBER_OF_COLUMNS = "numberOfColumns";
    public static final String COLUMN_IDS = "columnIds";
    public static final String COLUMN_TYPES = "columnTypes";
    public static final String ESTIMATED_SIZE = "estimatedSize";
    public static final String DEFINITION = "definition";
    private DataSetDefJSONMarshaller dataSetDefJSONMarshaller;

    public DataSetMetadataJSONMarshaller() {
    }

    public DataSetMetadataJSONMarshaller(DataSetDefJSONMarshaller dataSetDefJSONMarshaller) {
        this.dataSetDefJSONMarshaller = dataSetDefJSONMarshaller;
    }

    public DataSetMetadata fromJSON(String json) {
        JsonObject jsonObj = Json.parse((String)json);
        return this.fromJsonObj(jsonObj);
    }

    public DataSetMetadata fromJsonObj(JsonObject json) {
        JsonObject definitionObj = json.getObject(DEFINITION);
        String uuid = json.getString(UUID);
        int numberOfRows = json.getNumber(NUMBER_OF_ROWS).intValue();
        int numberOfColumns = json.getNumber(NUMBER_OF_COLUMNS).intValue();
        JsonArray columnIdsArray = this.getArray(json, COLUMN_IDS);
        JsonArray columnTypesArray = this.getArray(json, COLUMN_TYPES);
        int estimatedSize = json.getNumber(ESTIMATED_SIZE).intValue();
        List<String> columnIds = IntStream.range(0, columnIdsArray.length()).mapToObj(arg_0 -> ((JsonArray)columnIdsArray).getString(arg_0)).collect(Collectors.toList());
        List<ColumnType> columnTypes = IntStream.range(0, columnTypesArray.length()).mapToObj(arg_0 -> ((JsonArray)columnTypesArray).getString(arg_0)).map(ColumnType::getByName).collect(Collectors.toList());
        DataSetDef definition = null;
        if (definitionObj != null) {
            try {
                definition = this.dataSetDefJSONMarshaller.fromJsonObj(definitionObj);
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing data set definition");
            }
        }
        return new DataSetMetadataImpl(definition, uuid, numberOfRows, numberOfColumns, columnIds, columnTypes, estimatedSize);
    }

    public String toJson(DataSetMetadata dataSetMetadata) {
        return this.toJSONObj(dataSetMetadata).toJson();
    }

    public JsonObject toJSONObj(DataSetMetadata dataSetMetadata) {
        JsonObject metadataJsonObj = Json.createObject();
        metadataJsonObj.set(UUID, (JsonValue)Json.create((String)dataSetMetadata.getUUID()));
        metadataJsonObj.set(NUMBER_OF_ROWS, (JsonValue)Json.create((double)dataSetMetadata.getNumberOfRows()));
        metadataJsonObj.set(NUMBER_OF_COLUMNS, (JsonValue)Json.create((double)dataSetMetadata.getNumberOfColumns()));
        JsonArray columnIdsJsonArray = Json.createArray();
        this.listToJsonArray(dataSetMetadata.getColumnIds(), columnIdsJsonArray);
        metadataJsonObj.set(COLUMN_IDS, (JsonValue)columnIdsJsonArray);
        JsonArray columnTypesJsonArray = Json.createArray();
        this.listToJsonArray(dataSetMetadata.getColumnTypes(), columnTypesJsonArray);
        metadataJsonObj.set(COLUMN_TYPES, (JsonValue)columnTypesJsonArray);
        metadataJsonObj.set(ESTIMATED_SIZE, (JsonValue)Json.create((double)dataSetMetadata.getEstimatedSize()));
        metadataJsonObj.set(DEFINITION, (JsonValue)this.dataSetDefJSONMarshaller.toJsonObject(dataSetMetadata.getDefinition()));
        return metadataJsonObj;
    }

    private void listToJsonArray(List<?> list, JsonArray columnIdsJsonArray) {
        for (int i = 0; i < list.size(); ++i) {
            columnIdsJsonArray.set(i, list.get(i).toString());
        }
    }

    private JsonArray getArray(JsonObject json, String fieldName) {
        JsonArray array = json.getArray(fieldName);
        return array == null ? Json.createArray() : array;
    }
}

