/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.AbstractDataSetOp;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.json.Json;
import org.dashbuilder.json.JsonArray;
import org.dashbuilder.json.JsonException;
import org.dashbuilder.json.JsonNull;
import org.dashbuilder.json.JsonObject;
import org.dashbuilder.json.JsonType;
import org.dashbuilder.json.JsonValue;

public class DataSetLookupJSONMarshaller {
    private static final String UUID = "dataSetUuid";
    private static final String ROWCOUNT = "rowCount";
    private static final String ROWOFFSET = "rowOffset";
    protected static final String COLUMN = "column";
    private static final String SOURCE = "source";
    private static final String FILTEROPS = "filterOps";
    protected static final String FUNCTION_TYPE = "function";
    protected static final String FUNCTION_ARGS = "args";
    protected static final String FUNCTION_LABEL_VALUE = "labelValue";
    private static final String GROUPOPS = "groupOps";
    private static final String COLUMNGROUP = "columnGroup";
    private static final String GROUPSTRATEGY = "groupStrategy";
    private static final String MAXINTERVALS = "maxIntervals";
    private static final String INTERVALSIZE = "intervalSize";
    private static final String EMPTYINTERVALS = "emptyIntervals";
    private static final String ASCENDING = "asc";
    private static final String FIRSTMONTHOFYEAR = "firstMonthOfYear";
    private static final String FIRSTDAYOFWEEK = "firstDayOfWeek";
    private static final String GROUPFUNCTIONS = "groupFunctions";
    protected static final String FUNCTION = "function";
    private static final String SELECTEDINTERVALS = "selected";
    private static final String INTERVAL_NAME = "name";
    private static final String INTERVAL_TYPE = "type";
    private static final String INTERVAL_IDX = "index";
    private static final String INTERVAL_MIN = "min";
    private static final String INTERVAL_MAX = "max";
    private static final String JOIN = "join";
    private static final String SORTOPS = "sortOps";
    private static final String SORTORDER = "sortOrder";
    private static Map<String, Collection<String>> _keysAliasMap = new HashMap<String, Collection<String>>();
    private static DataSetLookupJSONMarshaller SINGLETON;
    private List<String> coreFunctionTypes = new ArrayList<String>();
    private List<String> logicalFunctionTypes = new ArrayList<String>();

    public static DataSetLookupJSONMarshaller get() {
        return SINGLETON;
    }

    private Collection<String> keySet(String key) {
        return _keysAliasMap.get(key);
    }

    public DataSetLookupJSONMarshaller() {
        for (LogicalExprType logicalExprType : LogicalExprType.values()) {
            this.logicalFunctionTypes.add(logicalExprType.toString());
        }
        for (Enum enum_ : CoreFunctionType.values()) {
            this.coreFunctionTypes.add(enum_.toString());
        }
    }

    public JsonObject toJson(DataSetLookup dataSetLookup) throws JsonException {
        JsonObject json = Json.createObject();
        if (dataSetLookup != null) {
            List<DataSetSort> sortOps;
            List<DataSetGroup> groupOps;
            String uuid = dataSetLookup.getDataSetUUID();
            if (uuid != null && !uuid.trim().isEmpty()) {
                json.put(UUID, uuid);
            }
            json.put(ROWCOUNT, Integer.toString(dataSetLookup.getNumberOfRows()));
            json.put(ROWOFFSET, Integer.toString(dataSetLookup.getRowOffset()));
            List<DataSetFilter> filterOps = dataSetLookup.getOperationList(DataSetFilter.class);
            if (!filterOps.isEmpty()) {
                json.set(FILTEROPS, (JsonValue)this.formatFilterOperations(filterOps));
            }
            if (!(groupOps = dataSetLookup.getOperationList(DataSetGroup.class)).isEmpty()) {
                json.set(GROUPOPS, (JsonValue)this.formatGroupOperations(groupOps));
            }
            if (!(sortOps = dataSetLookup.getOperationList(DataSetSort.class)).isEmpty()) {
                json.set(SORTOPS, (JsonValue)this.formatSortOperations(sortOps));
            }
        }
        return json;
    }

    public JsonArray formatFilterOperations(List<DataSetFilter> filterOps) throws JsonException {
        if (filterOps.isEmpty()) {
            return null;
        }
        return this.formatColumnFilters(filterOps.get(0).getColumnFilterList());
    }

    public JsonArray formatColumnFilters(List<ColumnFilter> columnFilters) throws JsonException {
        JsonArray colFiltersJsonArray = Json.createArray();
        int colFilterCounter = 0;
        for (ColumnFilter columnFilter : columnFilters) {
            colFiltersJsonArray.set(colFilterCounter++, (JsonValue)this.formatColumnFilter(columnFilter));
        }
        return colFiltersJsonArray;
    }

    public JsonObject formatColumnFilter(ColumnFilter columnFilter) throws JsonException {
        if (columnFilter == null) {
            return null;
        }
        JsonObject colFilterJson = Json.createObject();
        if (columnFilter instanceof LogicalExprFilter) {
            LogicalExprFilter lef = (LogicalExprFilter)columnFilter;
            colFilterJson.put(COLUMN, lef.getColumnId());
            colFilterJson.put("function", lef.getLogicalOperator().toString());
            colFilterJson.put(FUNCTION_ARGS, (JsonValue)this.formatColumnFilters(lef.getLogicalTerms()));
        } else if (columnFilter instanceof CoreFunctionFilter) {
            CoreFunctionFilter cff = (CoreFunctionFilter)columnFilter;
            colFilterJson.put(COLUMN, cff.getColumnId());
            colFilterJson.put("function", cff.getType().toString());
            colFilterJson.put(FUNCTION_LABEL_VALUE, cff.getLabelValue());
            JsonArray paramsJsonArray = Json.createArray();
            int paramCounter = 0;
            for (Object param : cff.getParameters()) {
                JsonValue jsonParam = this.formatValue(param);
                paramsJsonArray.set(paramCounter++, jsonParam);
            }
            colFilterJson.put(FUNCTION_ARGS, (JsonValue)paramsJsonArray);
        } else {
            throw new IllegalArgumentException("Unsupported column filter");
        }
        return colFilterJson;
    }

    public JsonArray formatGroupOperations(List<DataSetGroup> groupOps) throws JsonException {
        if (groupOps.isEmpty()) {
            return null;
        }
        JsonArray groupOpsJsonArray = Json.createArray();
        int groupOpCounter = 0;
        for (DataSetGroup groupOp : groupOps) {
            groupOpsJsonArray.set(groupOpCounter++, (JsonValue)this.formatDataSetGroup(groupOp));
        }
        return groupOpsJsonArray;
    }

    public JsonObject formatDataSetGroup(DataSetGroup dataSetGroup) throws JsonException {
        if (dataSetGroup == null) {
            return null;
        }
        JsonObject dataSetGroupJson = Json.createObject();
        dataSetGroupJson.put(COLUMNGROUP, (JsonValue)this.formatColumnGroup(dataSetGroup.getColumnGroup()));
        dataSetGroupJson.put(GROUPFUNCTIONS, (JsonValue)this.formatGroupFunctions(dataSetGroup.getGroupFunctions()));
        dataSetGroupJson.put(SELECTEDINTERVALS, (JsonValue)this.formatSelectedIntervals(dataSetGroup.getSelectedIntervalList()));
        dataSetGroupJson.put(JOIN, dataSetGroup.isJoin() ? "true" : "false");
        return dataSetGroupJson;
    }

    public JsonObject formatColumnGroup(ColumnGroup columnGroup) throws JsonException {
        if (columnGroup == null) {
            return null;
        }
        JsonObject columnGroupJson = Json.createObject();
        columnGroupJson.put(SOURCE, columnGroup.getSourceId() != null ? columnGroup.getSourceId() : null);
        columnGroupJson.put(COLUMN, columnGroup.getColumnId() != null ? columnGroup.getColumnId() : null);
        columnGroupJson.put(GROUPSTRATEGY, columnGroup.getStrategy() != null ? columnGroup.getStrategy().toString() : null);
        columnGroupJson.put(MAXINTERVALS, Integer.toString(columnGroup.getMaxIntervals()));
        columnGroupJson.put(INTERVALSIZE, columnGroup.getIntervalSize() != null ? columnGroup.getIntervalSize() : null);
        columnGroupJson.put(EMPTYINTERVALS, columnGroup.areEmptyIntervalsAllowed() ? "true" : "false");
        columnGroupJson.put(ASCENDING, columnGroup.isAscendingOrder() ? "true" : "false");
        columnGroupJson.put(FIRSTMONTHOFYEAR, columnGroup.getFirstMonthOfYear() != null ? columnGroup.getFirstMonthOfYear().toString() : null);
        columnGroupJson.put(FIRSTDAYOFWEEK, columnGroup.getFirstDayOfWeek() != null ? columnGroup.getFirstDayOfWeek().toString() : null);
        return columnGroupJson;
    }

    public JsonArray formatGroupFunctions(List<GroupFunction> groupFunctions) throws JsonException {
        if (groupFunctions.isEmpty()) {
            return null;
        }
        JsonArray groupOpsJsonArray = Json.createArray();
        int groupFunctionCounter = 0;
        for (GroupFunction groupFunction : groupFunctions) {
            groupOpsJsonArray.set(groupFunctionCounter++, (JsonValue)this.formatGroupFunction(groupFunction));
        }
        return groupOpsJsonArray;
    }

    public JsonObject formatGroupFunction(GroupFunction groupFunction) throws JsonException {
        if (groupFunction == null) {
            return null;
        }
        JsonObject groupFunctionJson = Json.createObject();
        groupFunctionJson.put(SOURCE, groupFunction.getSourceId() != null ? groupFunction.getSourceId() : null);
        groupFunctionJson.put(COLUMN, groupFunction.getColumnId() != null ? groupFunction.getColumnId() : null);
        groupFunctionJson.put("function", groupFunction.getFunction() != null ? groupFunction.getFunction().toString() : null);
        return groupFunctionJson;
    }

    public JsonArray formatSelectedIntervals(List<Interval> selectedIntervalList) throws JsonException {
        if (selectedIntervalList.isEmpty()) {
            return null;
        }
        JsonArray selectedIntervalNamesJsonArray = Json.createArray();
        int intervalNamesCounter = 0;
        for (Interval interval : selectedIntervalList) {
            selectedIntervalNamesJsonArray.set(intervalNamesCounter++, (JsonValue)this.formatInterval(interval));
        }
        return selectedIntervalNamesJsonArray;
    }

    public JsonObject formatInterval(Interval interval) throws JsonException {
        if (interval == null) {
            return null;
        }
        JsonObject jsonObj = Json.createObject();
        jsonObj.put(INTERVAL_NAME, interval.getName());
        jsonObj.put(INTERVAL_IDX, Integer.toString(interval.getIndex()));
        if (interval.getType() != null) {
            jsonObj.put(INTERVAL_TYPE, interval.getName());
        }
        if (interval.getMinValue() != null) {
            jsonObj.put(INTERVAL_MIN, this.formatValue(interval.getMinValue()));
        }
        if (interval.getMinValue() != null) {
            jsonObj.put(INTERVAL_MAX, this.formatValue(interval.getMaxValue()));
        }
        return jsonObj;
    }

    public JsonArray formatSortOperations(List<DataSetSort> sortOps) throws JsonException {
        if (sortOps.isEmpty()) {
            return null;
        }
        return this.formatColumnSorts(sortOps.get(0).getColumnSortList());
    }

    public JsonArray formatColumnSorts(List<ColumnSort> columnSorts) throws JsonException {
        if (columnSorts.isEmpty()) {
            return null;
        }
        JsonArray columnSortsJsonArray = Json.createArray();
        int columnSortCounter = 0;
        for (ColumnSort columnSort : columnSorts) {
            columnSortsJsonArray.set(columnSortCounter++, (JsonValue)this.formatColumnSort(columnSort));
        }
        return columnSortsJsonArray;
    }

    public JsonObject formatColumnSort(ColumnSort columnSort) throws JsonException {
        if (columnSort == null) {
            return null;
        }
        JsonObject columnSortJson = Json.createObject();
        columnSortJson.put(COLUMN, columnSort.getColumnId() != null ? columnSort.getColumnId() : null);
        columnSortJson.put(SORTORDER, columnSort.getOrder() != null ? columnSort.getOrder().toString() : null);
        return columnSortJson;
    }

    public DataSetLookup fromJson(String jsonString) throws JsonException {
        if (jsonString == null || jsonString.trim().isEmpty()) {
            return null;
        }
        JsonObject dataSetLookupJson = Json.parse((String)jsonString);
        return this.fromJson(dataSetLookupJson);
    }

    public DataSetLookup fromJson(JsonObject json) throws JsonException {
        if (json == null) {
            return null;
        }
        DataSetLookup dataSetLookup = new DataSetLookup();
        dataSetLookup.setDataSetUUID(json.get(UUID) != null ? json.getString(UUID) : null);
        dataSetLookup.setNumberOfRows(json.get(ROWCOUNT) != null ? Integer.parseInt(json.getString(ROWCOUNT), 10) : -1);
        dataSetLookup.setRowOffset(json.get(ROWOFFSET) != null ? Integer.parseInt(json.getString(ROWOFFSET), 10) : 0);
        List<DataSetOp> dataSetOpList = dataSetLookup.getOperationList();
        List<AbstractDataSetOp> c = null;
        c = this.parseFilterOperations(json.getArray(FILTEROPS));
        if (c != null) {
            dataSetOpList.addAll(c);
        }
        if ((c = this.parseGroupOperations(json.getArray(GROUPOPS))) != null) {
            dataSetOpList.addAll(c);
        }
        if ((c = this.parseSortOperations(json.getArray(SORTOPS))) != null) {
            dataSetOpList.addAll(c);
        }
        return dataSetLookup;
    }

    public List<DataSetFilter> parseFilterOperations(JsonArray columnFiltersJsonArray) {
        if (columnFiltersJsonArray == null) {
            return null;
        }
        ArrayList<DataSetFilter> dataSetFilters = new ArrayList<DataSetFilter>();
        DataSetFilter dataSetFilter = this.parseFilterOperation(columnFiltersJsonArray);
        if (dataSetFilter != null) {
            dataSetFilters.add(dataSetFilter);
        }
        return dataSetFilters;
    }

    public DataSetFilter parseFilterOperation(JsonArray columnFiltersJsonArray) {
        if (columnFiltersJsonArray == null) {
            return null;
        }
        DataSetFilter dataSetFilter = new DataSetFilter();
        List<ColumnFilter> columnFilters = this.parseColumnFilters(columnFiltersJsonArray);
        if (columnFilters != null) {
            dataSetFilter.getColumnFilterList().addAll(columnFilters);
        }
        return dataSetFilter;
    }

    public List<ColumnFilter> parseColumnFilters(JsonArray columnFiltersJsonArray) {
        if (columnFiltersJsonArray == null) {
            return null;
        }
        ArrayList<ColumnFilter> columnFilters = new ArrayList<ColumnFilter>(columnFiltersJsonArray.length());
        for (int i = 0; i < columnFiltersJsonArray.length(); ++i) {
            columnFilters.add(this.parseColumnFilter(columnFiltersJsonArray.getObject(i)));
        }
        return columnFilters;
    }

    public ColumnFilter parseColumnFilter(JsonObject columnFilterJson) {
        if (columnFilterJson == null) {
            return null;
        }
        String columnId = columnFilterJson.getString(this.keySet(COLUMN));
        String functionType = columnFilterJson.getString(this.keySet("function"));
        JsonArray terms = columnFilterJson.getArray(this.keySet(FUNCTION_ARGS));
        if (functionType == null) {
            throw new RuntimeException("Dataset lookup column filter null function type");
        }
        if (this.isCoreFilter(functionType)) {
            String labelValue = columnFilterJson.getString(this.keySet(FUNCTION_LABEL_VALUE));
            CoreFunctionFilter cff = new CoreFunctionFilter();
            cff.setColumnId(columnId);
            cff.setType(CoreFunctionType.getByName(functionType));
            cff.setParameters(this.parseCoreFunctionParameters(terms));
            cff.setLabelValue(labelValue);
            return cff;
        }
        if (this.isLogicalFilter(functionType)) {
            LogicalExprFilter lef = new LogicalExprFilter();
            lef.setColumnId(columnId);
            lef.setLogicalOperator(LogicalExprType.getByName(functionType));
            lef.setLogicalTerms(this.parseColumnFilters(terms));
            return lef;
        }
        throw new RuntimeException("Dataset lookup column filter wrong type");
    }

    public List<Comparable> parseCoreFunctionParameters(JsonArray paramsJsonArray) {
        if (paramsJsonArray == null) {
            return null;
        }
        ArrayList<Comparable> params = new ArrayList<Comparable>(paramsJsonArray.length());
        for (int i = 0; i < paramsJsonArray.length(); ++i) {
            JsonValue jsonValue = paramsJsonArray.get(i);
            params.add(this.parseValue(jsonValue));
        }
        return params;
    }

    public List<DataSetGroup> parseGroupOperations(JsonArray groupOpsJsonArray) {
        if (groupOpsJsonArray == null) {
            return null;
        }
        ArrayList<DataSetGroup> dataSetGroups = new ArrayList<DataSetGroup>();
        for (int i = 0; i < groupOpsJsonArray.length(); ++i) {
            JsonObject dataSetGroupOpJson = groupOpsJsonArray.getObject(i);
            dataSetGroups.add(this.parseDataSetGroup(dataSetGroupOpJson));
        }
        return dataSetGroups;
    }

    public DataSetGroup parseDataSetGroup(JsonObject dataSetGroupJson) {
        List<GroupFunction> groupFunctions;
        if (dataSetGroupJson == null) {
            return null;
        }
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(null);
        JsonObject value = dataSetGroupJson.getObject(COLUMNGROUP);
        if (value != null) {
            dataSetGroup.setColumnGroup(this.parseColumnGroup(value));
        }
        if ((groupFunctions = this.parseGroupFunctions(dataSetGroupJson.getArray(GROUPFUNCTIONS))) != null) {
            dataSetGroup.getGroupFunctions().addAll(groupFunctions);
        }
        dataSetGroup.setSelectedIntervalList(this.parseSelectedIntervals(dataSetGroupJson.getArray(this.keySet(SELECTEDINTERVALS))));
        dataSetGroup.setJoin(dataSetGroupJson.getBoolean(JOIN));
        return dataSetGroup;
    }

    public ColumnGroup parseColumnGroup(JsonObject columnGroupJson) {
        if (columnGroupJson == null) {
            return null;
        }
        ColumnGroup columnGroup = new ColumnGroup();
        columnGroup.setSourceId(columnGroupJson.getString(this.keySet(SOURCE)));
        columnGroup.setColumnId(columnGroupJson.getString(this.keySet(COLUMN)));
        columnGroup.setStrategy(GroupStrategy.getByName(columnGroupJson.getString(GROUPSTRATEGY)));
        columnGroup.setMaxIntervals(columnGroupJson.getNumber(MAXINTERVALS, (Number)-1).intValue());
        columnGroup.setIntervalSize(columnGroupJson.getString(INTERVALSIZE));
        columnGroup.setEmptyIntervalsAllowed(columnGroupJson.getBoolean(EMPTYINTERVALS));
        columnGroup.setAscendingOrder(columnGroupJson.getBoolean(ASCENDING));
        columnGroup.setFirstMonthOfYear(Month.getByName(columnGroupJson.getString(FIRSTMONTHOFYEAR)));
        columnGroup.setFirstDayOfWeek(DayOfWeek.getByName(columnGroupJson.getString(FIRSTDAYOFWEEK)));
        return columnGroup;
    }

    public List<GroupFunction> parseGroupFunctions(JsonArray groupFunctionsJson) {
        if (groupFunctionsJson == null) {
            return null;
        }
        ArrayList<GroupFunction> groupFunctions = new ArrayList<GroupFunction>(groupFunctionsJson.length());
        for (int i = 0; i < groupFunctionsJson.length(); ++i) {
            groupFunctions.add(this.parseGroupFunction(groupFunctionsJson.getObject(i)));
        }
        return groupFunctions;
    }

    public GroupFunction parseGroupFunction(JsonObject groupFunctionJson) {
        if (groupFunctionJson == null) {
            return null;
        }
        GroupFunction groupFunction = new GroupFunction();
        groupFunction.setSourceId(groupFunctionJson.getString(this.keySet(SOURCE)));
        groupFunction.setColumnId(groupFunctionJson.getString(this.keySet(COLUMN)));
        groupFunction.setFunction(AggregateFunctionType.getByName(groupFunctionJson.getString(this.keySet("function"))));
        return groupFunction;
    }

    public List<Interval> parseSelectedIntervals(JsonArray selectedIntervalsJson) {
        if (selectedIntervalsJson == null) {
            return null;
        }
        ArrayList<Interval> intervalList = new ArrayList<Interval>(selectedIntervalsJson.length());
        for (int i = 0; i < selectedIntervalsJson.length(); ++i) {
            intervalList.add(this.parseInterval(selectedIntervalsJson.getObject(i)));
        }
        return intervalList;
    }

    public Interval parseInterval(JsonObject jsonObj) {
        if (jsonObj == null) {
            return null;
        }
        Interval interval = new Interval();
        interval.setName(jsonObj.getString(INTERVAL_NAME));
        interval.setType(jsonObj.getString(INTERVAL_TYPE));
        interval.setIndex(jsonObj.getNumber(INTERVAL_IDX, (Number)0).intValue());
        interval.setMinValue(this.parseValue(jsonObj.get(INTERVAL_MIN)));
        interval.setMaxValue(this.parseValue(jsonObj.get(INTERVAL_MAX)));
        return interval;
    }

    public List<DataSetSort> parseSortOperations(JsonArray columnSortsJsonArray) {
        if (columnSortsJsonArray == null) {
            return null;
        }
        ArrayList<DataSetSort> dataSetSorts = new ArrayList<DataSetSort>();
        DataSetSort dataSetSort = new DataSetSort();
        dataSetSorts.add(dataSetSort);
        List<ColumnSort> columnSorts = this.parseColumnSorts(columnSortsJsonArray);
        if (columnSorts != null) {
            dataSetSort.getColumnSortList().addAll(columnSorts);
        }
        return dataSetSorts;
    }

    public List<ColumnSort> parseColumnSorts(JsonArray columnSortsJsonArray) {
        if (columnSortsJsonArray == null) {
            return null;
        }
        ArrayList<ColumnSort> columnSorts = new ArrayList<ColumnSort>(columnSortsJsonArray.length());
        for (int i = 0; i < columnSortsJsonArray.length(); ++i) {
            columnSorts.add(this.parseColumnSort(columnSortsJsonArray.getObject(i)));
        }
        return columnSorts;
    }

    public ColumnSort parseColumnSort(JsonObject columnSortJson) {
        if (columnSortJson == null) {
            return null;
        }
        ColumnSort columnSort = new ColumnSort();
        columnSort.setColumnId(columnSortJson.getString(COLUMN));
        columnSort.setOrder(SortOrder.getByName(columnSortJson.getString(SORTORDER)));
        return columnSort;
    }

    public boolean isLogicalFilter(String functionType) {
        return this.logicalFunctionTypes.contains(functionType);
    }

    public boolean isCoreFilter(String functionType) {
        return this.coreFunctionTypes.contains(functionType);
    }

    public String twoDigits(int n) {
        String str = String.valueOf(n);
        return n < 10 ? "0" + str : str;
    }

    public String formatDate(Date d) {
        return 1900 + d.getYear() + "-" + this.twoDigits(d.getMonth() + 1) + "-" + this.twoDigits(d.getDate()) + " " + this.twoDigits(d.getHours()) + ":" + this.twoDigits(d.getMinutes()) + ":" + this.twoDigits(d.getSeconds());
    }

    public Date parseDate(String date) {
        String str = date.trim();
        if (str.length() != 19) {
            throw new JsonException("Wrong date format: " + str);
        }
        try {
            int year = Integer.parseInt(str.substring(0, 4));
            int month = Integer.parseInt(str.substring(5, 7)) - 1;
            int day = Integer.parseInt(str.substring(8, 10));
            int hour = Integer.parseInt(str.substring(11, 13));
            int min = Integer.parseInt(str.substring(14, 16));
            int sec = Integer.parseInt(str.substring(17, 19));
            if (month > 11 || month < 0 || day < 1 || day > 31 || hour > 23 || hour < 0 || min > 59 || min < 0 || sec > 59 || sec < 0) {
                throw new JsonException("Wrong date format: " + str);
            }
            return new Date(year - 1900, month, day, hour, min, sec);
        }
        catch (NumberFormatException e) {
            throw new JsonException("Wrong date format: " + str);
        }
    }

    public JsonValue formatValue(Object value) {
        if (value == null) {
            return JsonNull.NULL_INSTANCE;
        }
        if (value instanceof Number) {
            return Json.create((double)((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return Json.create((boolean)((Boolean)value));
        }
        if (value instanceof Date) {
            return Json.create((String)this.formatDate((Date)value));
        }
        return Json.create((String)value.toString());
    }

    public Comparable parseValue(JsonValue jsonValue) {
        if (jsonValue == null || jsonValue.getType().equals((Object)JsonType.NULL)) {
            return null;
        }
        if (jsonValue.getType().equals((Object)JsonType.BOOLEAN)) {
            return Boolean.valueOf(jsonValue.asBoolean());
        }
        if (jsonValue.getType().equals((Object)JsonType.NUMBER)) {
            return Double.valueOf(jsonValue.asNumber());
        }
        try {
            return this.parseDate(jsonValue.asString());
        }
        catch (Exception e1) {
            return jsonValue.asString();
        }
    }

    static {
        _keysAliasMap.put("function", Arrays.asList("function", "functionType"));
        _keysAliasMap.put(FUNCTION_ARGS, Arrays.asList(FUNCTION_ARGS, "terms"));
        _keysAliasMap.put(COLUMN, Arrays.asList(COLUMN, "columnId"));
        _keysAliasMap.put(SOURCE, Arrays.asList(SOURCE, "sourceId"));
        _keysAliasMap.put(FUNCTION_LABEL_VALUE, Arrays.asList(FUNCTION_LABEL_VALUE, FUNCTION_LABEL_VALUE));
        _keysAliasMap.put(SELECTEDINTERVALS, Arrays.asList(SELECTEDINTERVALS, "selectedIntervals"));
        SINGLETON = new DataSetLookupJSONMarshaller();
    }
}

