/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder.dialect.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.compiler.lang.descr.ProcessDescr;
import org.drools.core.util.KieFunctions;
import org.drools.core.util.StringUtils;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.ProcessClassBuilder;
import org.jbpm.process.core.Process;

public class JavaProcessClassBuilder
implements ProcessClassBuilder {
    protected static List<String> systemImports = new ArrayList<String>();

    @Override
    public String buildRule(ProcessBuildContext context) {
        if (context.getMethods().isEmpty()) {
            return null;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder();
        buffer.append("package " + context.getPkg().getName() + ";" + lineSeparator);
        if (context.getProcess() != null && ((Process)context.getProcess()).getImports() != null) {
            for (String decl : ((Process)context.getProcess()).getImports()) {
                buffer.append("import " + decl + ";" + lineSeparator);
            }
        }
        for (String systemImport : systemImports) {
            if (context.getPkg().getImports().containsKey(systemImport)) continue;
            buffer.append("import ").append(systemImport).append(";").append(lineSeparator);
        }
        Iterator it = context.getPkg().getStaticImports().iterator();
        while (it.hasNext()) {
            buffer.append("import static " + it.next() + ";" + lineSeparator);
        }
        ProcessDescr processDescr = context.getProcessDescr();
        buffer.append("public class " + StringUtils.ucFirst((String)processDescr.getClassName()) + " {" + lineSeparator);
        buffer.append("    private static final long serialVersionUID = 510l;" + lineSeparator);
        int size = context.getMethods().size();
        for (int i = 0; i < size; ++i) {
            buffer.append((String)context.getMethods().get(i) + lineSeparator);
        }
        String[] lines = buffer.toString().split(lineSeparator);
        buffer.append("}");
        return buffer.toString();
    }

    static {
        systemImports.add(KieFunctions.class.getName());
    }
}

