/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder.dialect;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.feel.FeelProcessDialect;
import org.jbpm.process.builder.dialect.java.JavaProcessDialect;
import org.jbpm.process.builder.dialect.javascript.JavaScriptProcessDialect;
import org.jbpm.process.builder.dialect.mvel.MVELProcessDialect;

public class ProcessDialectRegistry {
    private static ConcurrentMap<String, ProcessDialect> dialects = new ConcurrentHashMap<String, ProcessDialect>();

    public static ProcessDialect getDialect(String dialect) {
        return (ProcessDialect)dialects.get(dialect);
    }

    public static void setDialect(String dialectName, ProcessDialect dialect) {
        dialects.put(dialectName, dialect);
    }

    public static Collection<String> getDialects() {
        return Collections.unmodifiableSet(dialects.keySet());
    }

    static {
        dialects.put("java", new JavaProcessDialect());
        dialects.put("mvel", new MVELProcessDialect());
        dialects.put("JavaScript", new JavaScriptProcessDialect());
        dialects.put("FEEL", new FeelProcessDialect());
    }
}

