/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.support;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataContributor;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.mapping.PersistentClass;
import org.jboss.jandex.IndexView;
import org.jbpm.persistence.api.JbpmEntityContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmMetadataContributor
implements MetadataContributor {
    private static final Logger log = LoggerFactory.getLogger(JbpmMetadataContributor.class);
    private List<JbpmEntityContributor> contributors = new ArrayList<JbpmEntityContributor>();

    public JbpmMetadataContributor() {
        ServiceLoader<JbpmEntityContributor> serviceLoader = ServiceLoader.load(JbpmEntityContributor.class);
        serviceLoader.forEach(sl -> this.contributors.add((JbpmEntityContributor)sl));
    }

    public void contribute(InFlightMetadataCollector metadataCollector, IndexView jandexIndex) {
        List entityDisableChecks = this.contributors.stream().flatMap(e -> e.disableInsertChecks().stream()).collect(Collectors.toList());
        for (String entity : entityDisableChecks) {
            log.debug("disabling row count check for entity {}", (Object)entity);
            ((PersistentClass)metadataCollector.getEntityBindingMap().get(entity)).setCustomSQLInsert(null, false, ExecuteUpdateResultCheckStyle.NONE);
        }
    }
}

