/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.sitegenerator;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.codehaus.plexus.util.io.RawInputStreamFacade;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.FeatureDescription;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.osgitools.EclipseRepositoryProject;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.UpdateSite;
import org.eclipse.tycho.packaging.AbstractTychoPackagingMojo;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Mojo(name="generate-repository-facade", defaultPhase=LifecyclePhase.PACKAGE)
public class GenerateRepositoryFacadeMojo
extends AbstractTychoPackagingMojo {
    public static final Set<String> defaultSystemProperties = new HashSet<String>(Arrays.asList("BUILD_ALIAS", "JOB_NAME", "BUILD_NUMBER", "BUILD_ID", "RELEASE", "ZIPSUFFIX", "TARGET_PLATFORM_VERSION", "TARGET_PLATFORM_VERSION_MAXIMUM", "NODE_NAME", "HOSTNAME", "WORKSPACE", "os.name", "os.version", "os.arch", "java.vendor", "java.version", "user.dir"));
    private static final String UPSTREAM_ELEMENT = "upstream";
    public static final String BUILDINFO_JSON = "buildinfo.json";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter
    private Map<String, String> symbols;
    @Parameter
    private File siteTemplateFolder;
    @Parameter
    private List<File> additionalWebResources;
    @Parameter
    private List<String> associateSites;
    @Parameter(defaultValue="embedReferences")
    private ReferenceStrategy referenceStrategy;
    @Parameter(defaultValue="index.html")
    private String indexName;
    @Parameter(defaultValue="site.css")
    private String cssName;
    @Parameter(defaultValue="false")
    private boolean removeDefaultCategory;
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Parameter(defaultValue="false")
    private boolean skipWebContentGeneration;
    @Parameter
    private String p2StatsUrl;
    @Parameter(defaultValue="latest/all/repo")
    private String fallbackToChild;
    @Parameter
    private Set<String> systemProperties;
    private File categoryFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"eclipse-repository".equals(this.project.getPackaging())) {
            return;
        }
        if (this.systemProperties == null) {
            this.systemProperties = defaultSystemProperties;
        }
        this.categoryFile = new File(this.project.getBasedir(), "category.xml");
        if (!this.categoryFile.isFile()) {
            return;
        }
        if (this.symbols == null) {
            this.symbols = new HashMap<String, String>();
        }
        File outputRepository = new File(this.project.getBuild().getDirectory(), "repository");
        File buildinfoFolder = new File(this.project.getBuild().getDirectory(), "buildinfo");
        buildinfoFolder.mkdirs();
        if (!this.skipWebContentGeneration) {
            try {
                this.copyTemplateResources(outputRepository);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Error while copying siteTemplateFolder content to " + outputRepository, ex);
            }
            if (this.additionalWebResources != null) {
                for (File resource : this.additionalWebResources) {
                    try {
                        if (resource.isDirectory()) {
                            FileUtils.copyDirectoryStructure((File)resource, (File)new File(outputRepository, resource.getName()));
                            continue;
                        }
                        if (!resource.isFile()) continue;
                        FileUtils.copyFile((File)resource, (File)new File(outputRepository, resource.getName()));
                    }
                    catch (Exception ex) {
                        throw new MojoExecutionException("Error while copying resource " + resource.getPath(), ex);
                    }
                }
            }
            File outputCategoryXml = this.generateCategoryXml(outputRepository);
            if (new File(outputRepository, "features").isDirectory()) {
                this.generateSiteProperties(outputRepository, outputCategoryXml);
            }
            this.generateWebStuff(outputRepository, outputCategoryXml);
        }
        try {
            this.alterContentJar(outputRepository);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error while altering content.jar", ex);
        }
        if (this.p2StatsUrl != null) {
            try {
                this.addP2Stats(outputRepository);
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Error while adding p2.stats to repository", ex);
            }
        }
        if (this.associateSites != null && !this.associateSites.isEmpty() && this.referenceStrategy == ReferenceStrategy.compositeReferences) {
            try {
                this.createCompositeReferences(outputRepository, this.associateSites);
            }
            catch (IOException ex) {
                throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
            }
        }
        this.createBuildInfo(outputRepository, buildinfoFolder);
        File repoZipFile = new File(this.project.getBuild().getDirectory(), this.project.getArtifactId() + "-" + this.project.getVersion() + ".zip");
        repoZipFile.delete();
        ZipArchiver archiver = new ZipArchiver();
        archiver.setDestFile(repoZipFile);
        archiver.setForced(true);
        archiver.addDirectory(outputRepository);
        try {
            archiver.createArchive();
        }
        catch (IOException ex) {
            throw new MojoFailureException("Could not create " + repoZipFile.getName(), (Throwable)ex);
        }
    }

    private void createCompositeReferences(File outputRepository, List<String> associateSites2) throws IOException {
        long timestamp = System.currentTimeMillis();
        String repoName = this.project.getName();
        if (repoName == null) {
            repoName = this.project.getArtifactId();
        }
        File referencesDir = new File(outputRepository, "references");
        referencesDir.mkdir();
        File contentXmlReference = new File(referencesDir, "content.xml");
        StringBuilder content = new StringBuilder();
        content.append("<?xml version='1.0' encoding='UTF-8' standalone='yes'?>").append('\n').append("<?metadataRepository version='1.1.0'?>").append('\n').append("<repository name='References for").append(repoName).append("' type='org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository' version='1'>").append('\n').append("  <properties size='1'>").append('\n').append("    <property name='p2.timestamp' value='").append(timestamp).append("'/>").append('\n').append("  </properties>").append('\n').append("  <references size='").append(2 * associateSites2.size()).append("'>").append('\n');
        for (String site : associateSites2) {
            content.append("      <repository options='1' type='0' uri='").append(site).append("' url='").append(site).append("'/>").append('\n');
            content.append("      <repository options='1' type='1' uri='").append(site).append("' url='").append(site).append("'/>").append('\n');
        }
        content.append("  </references>").append('\n');
        content.append("</repository>");
        org.apache.commons.io.FileUtils.writeStringToFile((File)contentXmlReference, (String)content.toString());
        File compositeWithRefDir = new File(outputRepository, "withreferences");
        compositeWithRefDir.mkdir();
        File compositeContentXml = new File(compositeWithRefDir, "compositeContent.xml");
        StringBuilder compositeContent = new StringBuilder();
        compositeContent.append("<?compositeMetadataRepository version='1.0.0'?>").append('\n').append("<repository name='").append(repoName).append("' type='org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository' version='1.0.0'>").append('\n').append("  <properties size='2'>").append('\n').append("    <property name='p2.compressed' value='true'/>").append('\n').append("    <property name='p2.timestamp' value='").append(timestamp).append("'/>").append('\n').append("  </properties>").append("\n").append("  <children size='2'>").append("\n").append("    <child location='../'/>").append('\n').append("    <child location='../references'/>").append('\n').append("  </children>").append('\n').append("</repository>");
        org.apache.commons.io.FileUtils.writeStringToFile((File)compositeContentXml, (String)compositeContent.toString());
        File compositeArtifactsXml = new File(compositeWithRefDir, "compositeArtifacts.xml");
        StringBuilder compositeArtifact = new StringBuilder();
        compositeArtifact.append("<?compositeArtifactRepository version='1.0.0'?>").append('\n').append("<repository name='").append(repoName).append("' type='org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository' version='1.0.0'>").append('\n').append("  <properties size='2'>").append('\n').append("    <property name='p2.compressed' value='true'/>").append('\n').append("    <property name='p2.timestamp' value='").append(timestamp).append("'/>").append('\n').append("  </properties>").append("\n").append("  <children size='1'>").append("\n").append("    <child location='../'/>").append('\n').append("  </children>").append('\n').append("</repository>");
        org.apache.commons.io.FileUtils.writeStringToFile((File)compositeArtifactsXml, (String)compositeArtifact.toString());
    }

    private void generateWebStuff(File outputRepository, File outputCategoryXml) throws TransformerFactoryConfigurationError, MojoExecutionException {
        try {
            InputStream siteXsl = ((Object)((Object)this)).getClass().getResourceAsStream("/xslt/site.xsl");
            StreamSource xsltSource = new StreamSource(siteXsl);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult res = new StreamResult(out);
            transformer.transform(new StreamSource(outputCategoryXml), res);
            siteXsl.close();
            this.symbols.put("${site.contents}", out.toString());
            out.close();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error occured while generating 'site.xsl'", ex);
        }
        try {
            this.alterIndexFile(outputRepository);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error writing file " + this.indexName, ex);
        }
    }

    private void generateSiteProperties(File outputRepository, File outputCategoryXml) throws TransformerFactoryConfigurationError, MojoExecutionException {
        try {
            InputStream siteXsl = ((Object)((Object)this)).getClass().getResourceAsStream("/xslt/site.properties.xsl");
            StreamSource xsltSource = new StreamSource(siteXsl);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
            FileOutputStream out = new FileOutputStream(new File(outputRepository, "site.properties"));
            StreamResult res = new StreamResult(out);
            transformer.transform(new StreamSource(outputCategoryXml), res);
            siteXsl.close();
            out.close();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error occured while generating 'site.properties'", ex);
        }
    }

    private File generateCategoryXml(File outputRepository) throws MojoExecutionException {
        UpdateSite site = null;
        try {
            site = UpdateSite.read((File)this.categoryFile);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not read 'category.xml' file", (Exception)ex);
        }
        new EclipseRepositoryProject().getDependencyWalker(this.project).traverseUpdateSite(site, new ArtifactDependencyVisitor(){

            public boolean visitFeature(FeatureDescription feature) {
                FeatureRef featureRef = feature.getFeatureRef();
                String id = featureRef.getId();
                ReactorProject otherProject = feature.getMavenProject();
                String version = otherProject != null ? otherProject.getExpandedVersion() : feature.getKey().getVersion();
                String url = "features/" + id + "_" + version + ".jar";
                ((UpdateSite.SiteFeatureRef)featureRef).setUrl(url);
                featureRef.setVersion(version);
                return false;
            }
        });
        File outputCategoryXml = new File(outputRepository, "category.xml");
        try {
            if (!outputCategoryXml.exists()) {
                outputCategoryXml.createNewFile();
            }
            UpdateSite.write((UpdateSite)site, (File)outputCategoryXml);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new MojoExecutionException("Could not write category.xml to '" + outputCategoryXml.getAbsolutePath() + "'", (Exception)ex);
        }
        return outputCategoryXml;
    }

    private void alterContentJar(File p2repository) throws FileNotFoundException, IOException, SAXException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        File contentJar = new File(p2repository, "content.jar");
        ZipInputStream contentStream = new ZipInputStream(new FileInputStream(contentJar));
        ZipEntry entry = null;
        Document contentDoc = null;
        boolean done = false;
        while (!done && (entry = contentStream.getNextEntry()) != null) {
            if (!entry.getName().equals("content.xml")) continue;
            contentDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(contentStream);
            Element repoElement = (Element)contentDoc.getElementsByTagName("repository").item(0);
            NodeList references = repoElement.getElementsByTagName("references");
            for (int i = 0; i < references.getLength(); ++i) {
                Node currentRef = references.item(i);
                currentRef.getParentNode().removeChild(currentRef);
            }
            if (this.associateSites != null && this.associateSites.size() > 0 && this.referenceStrategy == ReferenceStrategy.embedReferences) {
                Element refElement = contentDoc.createElement("references");
                refElement.setAttribute("size", Integer.valueOf(2 * this.associateSites.size()).toString());
                for (String associate : this.associateSites) {
                    Element rep0 = contentDoc.createElement("repository");
                    rep0.setAttribute("uri", associate);
                    rep0.setAttribute("url", associate);
                    rep0.setAttribute("type", "0");
                    rep0.setAttribute("options", "1");
                    refElement.appendChild(rep0);
                    Element rep1 = (Element)rep0.cloneNode(true);
                    rep1.setAttribute("type", "1");
                    refElement.appendChild(rep1);
                }
                repoElement.appendChild(refElement);
            }
            if (this.removeDefaultCategory) {
                Element unitsElement = (Element)repoElement.getElementsByTagName("units").item(0);
                NodeList units = unitsElement.getElementsByTagName("unit");
                for (int i = 0; i < units.getLength(); ++i) {
                    Element unit = (Element)units.item(i);
                    String id = unit.getAttribute("id");
                    if (id == null || !id.contains(".Default")) continue;
                    unit.getParentNode().removeChild(unit);
                }
                unitsElement.setAttribute("size", Integer.toString(unitsElement.getElementsByTagName("unit").getLength()));
            }
            done = true;
        }
        ZipOutputStream outContentStream = new ZipOutputStream(new FileOutputStream(contentJar));
        ZipEntry contentXmlEntry = new ZipEntry("content.xml");
        outContentStream.putNextEntry(contentXmlEntry);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("standalone", "yes");
        DOMSource source = new DOMSource(contentDoc);
        StreamResult result = new StreamResult(outContentStream);
        transformer.transform(source, result);
        contentStream.close();
        outContentStream.closeEntry();
        outContentStream.close();
    }

    private void addP2Stats(File p2repository) throws FileNotFoundException, IOException, SAXException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        File artifactsJar = new File(p2repository, "artifacts.jar");
        ZipInputStream contentStream = new ZipInputStream(new FileInputStream(artifactsJar));
        ZipEntry entry = null;
        Document contentDoc = null;
        boolean done = false;
        while (!done && (entry = contentStream.getNextEntry()) != null) {
            if (!entry.getName().equals("artifacts.xml")) continue;
            contentDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(contentStream);
            Element repoElement = (Element)contentDoc.getElementsByTagName("repository").item(0);
            Element repoProperties = (Element)contentDoc.getElementsByTagName("properties").item(0);
            int newRepoPropertiesSize = Integer.parseInt(repoProperties.getAttribute("size")) + 1;
            repoProperties.setAttribute("size", Integer.toString(newRepoPropertiesSize));
            Element p2statsElement = contentDoc.createElement("property");
            p2statsElement.setAttribute("name", "p2.statsURI");
            p2statsElement.setAttribute("value", this.p2StatsUrl);
            repoProperties.appendChild(p2statsElement);
            NodeList artifacts = ((Element)repoElement.getElementsByTagName("artifacts").item(0)).getElementsByTagName("artifact");
            for (int i = 0; i < artifacts.getLength(); ++i) {
                Element currentArtifact = (Element)artifacts.item(i);
                if (!currentArtifact.getAttribute("classifier").equals("org.eclipse.update.feature")) continue;
                String iu = currentArtifact.getAttribute("id");
                Element artifactProperties = (Element)currentArtifact.getElementsByTagName("properties").item(0);
                int newArtifactPropertiesSize = Integer.parseInt(artifactProperties.getAttribute("size")) + 1;
                artifactProperties.setAttribute("size", Integer.toString(newArtifactPropertiesSize));
                Element statsElement = contentDoc.createElement("property");
                statsElement.setAttribute("name", "download.stats");
                statsElement.setAttribute("value", iu);
                artifactProperties.appendChild(statsElement);
            }
            done = true;
        }
        ZipOutputStream outContentStream = new ZipOutputStream(new FileOutputStream(artifactsJar));
        ZipEntry contentXmlEntry = new ZipEntry("artifacts.xml");
        outContentStream.putNextEntry(contentXmlEntry);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(contentDoc);
        StreamResult result = new StreamResult(outContentStream);
        transformer.transform(source, result);
        contentStream.close();
        outContentStream.closeEntry();
        outContentStream.close();
    }

    private void alterIndexFile(File outputSite) throws FileNotFoundException, IOException {
        File templateFile = new File(outputSite, this.indexName);
        FileInputStream fis = new FileInputStream(templateFile);
        String htmlFile = IOUtil.toString((InputStream)fis, (String)"UTF-8");
        for (Map.Entry<String, String> entry : this.symbols.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("${")) {
                key = "${" + key + "}";
            }
            if (entry.getValue() == null) continue;
            htmlFile = htmlFile.replace(key, entry.getValue());
        }
        FileOutputStream out = new FileOutputStream(templateFile);
        out.write(htmlFile.getBytes("UTF-8"));
        fis.close();
        out.close();
    }

    private void copyTemplateResources(File outputSite) throws IOException, MojoExecutionException {
        this.getLog().debug((CharSequence)("Using outputSite = " + outputSite));
        this.getLog().debug((CharSequence)("Using siteTemplateFolder = " + this.siteTemplateFolder));
        if (this.siteTemplateFolder != null) {
            File webFolder;
            if (!this.siteTemplateFolder.isDirectory()) {
                throw new MojoExecutionException("'siteTemplateFolder' not correctly set. " + this.siteTemplateFolder.getAbsolutePath() + " is not a directory");
            }
            if (!outputSite.isDirectory()) {
                outputSite.mkdirs();
            }
            FileUtils.copyDirectoryStructure((File)this.siteTemplateFolder, (File)outputSite);
            if (!new File(outputSite, this.indexName).isFile()) {
                this.getLog().warn((CharSequence)("No " + this.siteTemplateFolder + "/" + this.indexName + " found; using default."));
                InputStream indexStream = ((Object)((Object)this)).getClass().getResourceAsStream("/index.html");
                FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(indexStream), (File)new File(outputSite, this.indexName));
                indexStream.close();
            }
            if (!(webFolder = new File(outputSite, "web")).exists()) {
                webFolder.mkdir();
            }
            if (!new File(webFolder, this.cssName).isFile()) {
                this.getLog().warn((CharSequence)("No " + webFolder + "/" + this.cssName + " found; using default."));
                InputStream cssStream = ((Object)((Object)this)).getClass().getResourceAsStream("/web/" + this.cssName);
                FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(cssStream), (File)new File(webFolder, this.cssName));
                cssStream.close();
            }
        } else {
            InputStream indexStream = ((Object)((Object)this)).getClass().getResourceAsStream("/index.html");
            FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(indexStream), (File)new File(outputSite, this.indexName));
            indexStream.close();
            File webFolder = new File(outputSite, "web");
            if (!webFolder.exists()) {
                webFolder.mkdir();
            }
            InputStream cssStream = ((Object)((Object)this)).getClass().getResourceAsStream("/web/" + this.cssName);
            FileUtils.copyStreamToFile((InputStreamFacade)new RawInputStreamFacade(cssStream), (File)new File(webFolder, this.cssName));
            cssStream.close();
        }
    }

    private void createBuildInfo(File outputRepository, File buildinfoFolder) throws MojoFailureException, MojoExecutionException {
        ModelNode jsonProperties = new ModelNode();
        jsonProperties.get("timestamp").set(System.currentTimeMillis());
        try {
            jsonProperties.get("revision").set(this.createRevisionObject());
        }
        catch (FileNotFoundException ex) {
            this.getLog().error((CharSequence)"Could not add revision to buildinfo.json: not a Git repository", (Throwable)ex);
        }
        catch (Exception ex) {
            throw new MojoFailureException("Could not add revision to buildinfo.json", (Throwable)ex);
        }
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            System.setProperty("HOSTNAME", localMachine.getHostName());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (System.getProperty("WORKSPACE") == null || System.getProperty("WORKSPACE").equals("")) {
            System.setProperty("WORKSPACE", Paths.get("", new String[0]).toAbsolutePath().toString());
        }
        ModelNode sysProps = new ModelNode();
        for (String propertyName : this.systemProperties) {
            sysProps.get(propertyName).set(String.valueOf(System.getProperty(propertyName)));
        }
        jsonProperties.get("properties").set(sysProps);
        try {
            jsonProperties.get(UPSTREAM_ELEMENT).set(this.aggregateUpstreamMetadata(buildinfoFolder));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not get upstream metadata", ex);
        }
        try {
            FileUtils.fileWrite((File)new File(buildinfoFolder, BUILDINFO_JSON), (String)jsonProperties.toJSONString(false));
            FileUtils.fileWrite((File)new File(outputRepository, BUILDINFO_JSON), (String)jsonProperties.toJSONString(false));
        }
        catch (Exception ex) {
            throw new MojoFailureException("Could not generate properties file", (Throwable)ex);
        }
    }

    /*
     * Exception decompiling
     */
    private ModelNode aggregateUpstreamMetadata(File buildinfoFolder) throws MojoFailureException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeUpstreamBuildinfoJSONFile(ModelNode obj, File buildinfoFolder) throws MojoFailureException {
        String projectName = this.getProjectName(obj);
        if (projectName != null) {
            String upstreamJSONFile = buildinfoFolder.toString() + File.separator + "buildinfo_" + projectName + ".json";
            this.getLog().debug((CharSequence)("Save to: " + upstreamJSONFile));
            try {
                buildinfoFolder.mkdirs();
                FileUtils.fileWrite((File)new File(upstreamJSONFile), (String)obj.toJSONString(false));
            }
            catch (Exception ex) {
                throw new MojoFailureException("Could not save JSON to " + upstreamJSONFile, (Throwable)ex);
            }
        }
    }

    private String getProjectName(ModelNode obj) {
        String projectURL = null;
        String projectName = null;
        for (Property prop : obj.get("revision").asPropertyList()) {
            if (projectURL != null || !prop.getName().equals("knownReferences") || !prop.getValue().isDefined()) continue;
            projectURL = ((ModelNode)prop.getValue().asList().get(0)).get("url").asString();
            this.getLog().debug((CharSequence)("Upstream repo: " + projectURL));
            projectName = projectURL.replaceAll(".+/([^/]+).git", "$1");
            this.getLog().debug((CharSequence)("Upstream proj: " + projectName));
        }
        return projectName;
    }

    private ModelNode createRevisionObject() throws IOException, FileNotFoundException {
        ModelNode res = new ModelNode();
        File repoRoot = GenerateRepositoryFacadeMojo.findRepoRoot(this.project.getBasedir());
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        Repository gitRepo = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(new File(repoRoot, ".git"))).readEnvironment()).findGitDir()).build();
        Ref head = gitRepo.getRef("HEAD");
        res.get("HEAD").set(head.getObjectId().getName());
        if (head.getTarget() != null && head.getTarget().getName() != null) {
            res.get("currentBranch").set(head.getTarget().getName());
        }
        ModelNode knownReferences = new ModelNode();
        for (Map.Entry entry : gitRepo.getAllRefs().entrySet()) {
            if (!((String)entry.getKey()).startsWith("refs/remotes/") || !((Ref)entry.getValue()).getObjectId().getName().equals(head.getObjectId().getName())) continue;
            ModelNode reference = new ModelNode();
            String remoteName = ((String)entry.getKey()).substring("refs/remotes/".length());
            remoteName = remoteName.substring(0, remoteName.indexOf(47));
            String remoteUrl = gitRepo.getConfig().getString("remote", remoteName, "url");
            String branchName = ((String)entry.getKey()).substring("refs/remotes/".length() + 1 + remoteName.length());
            reference.get("name").set(remoteName);
            reference.get("url").set(remoteUrl);
            reference.get("ref").set(branchName);
            knownReferences.add(reference);
        }
        res.get("knownReferences").set(knownReferences);
        return res;
    }

    protected static File findRepoRoot(File repoRoot) throws FileNotFoundException {
        while (!new File(repoRoot, ".git").isDirectory()) {
            repoRoot = repoRoot.getParentFile();
        }
        if (repoRoot == null) {
            throw new FileNotFoundException("Could not find a Git repository (with a .git child folder) in " + repoRoot);
        }
        return repoRoot;
    }

    private static enum ReferenceStrategy {
        embedReferences,
        compositeReferences;

    }
}

