/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import java.util.HashMap;
import java.util.List;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.xml.ForEachTag;
import org.apache.taglibs.standard.tag.common.xml.JSTLNodeList;
import org.apache.taglibs.standard.tag.common.xml.JSTLXPathConstants;
import org.apache.taglibs.standard.tag.common.xml.JSTLXPathFactory;
import org.apache.taglibs.standard.tag.common.xml.JSTLXPathNamespaceContext;
import org.apache.taglibs.standard.tag.common.xml.JSTLXPathVariableResolver;
import org.apache.taglibs.standard.tag.common.xml.UnresolvableException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtil {
    private static final String PAGE_NS_URL = "http://java.sun.com/jstl/xpath/page";
    private static final String REQUEST_NS_URL = "http://java.sun.com/jstl/xpath/request";
    private static final String SESSION_NS_URL = "http://java.sun.com/jstl/xpath/session";
    private static final String APP_NS_URL = "http://java.sun.com/jstl/xpath/app";
    private static final String PARAM_NS_URL = "http://java.sun.com/jstl/xpath/param";
    private static final String INITPARAM_NS_URL = "http://java.sun.com/jstl/xpath/initParam";
    private static final String COOKIE_NS_URL = "http://java.sun.com/jstl/xpath/cookie";
    private static final String HEADER_NS_URL = "http://java.sun.com/jstl/xpath/header";
    private PageContext pageContext;
    private static HashMap exprCache;
    private static JSTLXPathNamespaceContext jstlXPathNamespaceContext;
    private static final String XPATH_FACTORY_CLASS_NAME;
    private static XPathFactory XPATH_FACTORY;
    static DocumentBuilderFactory dbf;
    static DocumentBuilder db;
    static Document d;
    String modifiedXPath = null;

    public XPathUtil(PageContext pc) {
        this.pageContext = pc;
    }

    private static synchronized void staticInit() {
        if (jstlXPathNamespaceContext == null) {
            jstlXPathNamespaceContext = new JSTLXPathNamespaceContext();
            jstlXPathNamespaceContext.addNamespace("pageScope", PAGE_NS_URL);
            jstlXPathNamespaceContext.addNamespace("requestScope", REQUEST_NS_URL);
            jstlXPathNamespaceContext.addNamespace("sessionScope", SESSION_NS_URL);
            jstlXPathNamespaceContext.addNamespace("applicationScope", APP_NS_URL);
            jstlXPathNamespaceContext.addNamespace("param", PARAM_NS_URL);
            jstlXPathNamespaceContext.addNamespace("initParam", INITPARAM_NS_URL);
            jstlXPathNamespaceContext.addNamespace("header", HEADER_NS_URL);
            jstlXPathNamespaceContext.addNamespace("cookie", COOKIE_NS_URL);
            exprCache = new HashMap();
        }
    }

    static Document getDummyDocument() {
        try {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
            }
            db = dbf.newDocumentBuilder();
            DOMImplementation dim = db.getDOMImplementation();
            d = dim.createDocument("http://java.sun.com/jstl", "dummyroot", null);
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static Document getDummyDocumentWithoutRoot() {
        try {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
            }
            db = dbf.newDocumentBuilder();
            d = db.newDocument();
            return d;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String valueOf(Node n, String xpathString) throws JspTagException {
        XPathUtil.staticInit();
        JSTLXPathVariableResolver jxvr = new JSTLXPathVariableResolver(this.pageContext);
        Node contextNode = this.adaptParamsForXalan(n, xpathString.trim(), jxvr);
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(jstlXPathNamespaceContext);
        xpath.setXPathVariableResolver(jxvr);
        try {
            return xpath.evaluate(xpathString, contextNode);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    public boolean booleanValueOf(Node n, String xpathString) throws JspTagException {
        XPathUtil.staticInit();
        JSTLXPathVariableResolver jxvr = new JSTLXPathVariableResolver(this.pageContext);
        Node contextNode = this.adaptParamsForXalan(n, xpathString.trim(), jxvr);
        xpathString = this.modifiedXPath;
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(jstlXPathNamespaceContext);
        xpath.setXPathVariableResolver(jxvr);
        try {
            return (Boolean)xpath.evaluate(xpathString, contextNode, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(Resources.getMessage("XPATH_ERROR_XOBJECT", ex.toString()), ex);
        }
    }

    public List selectNodes(Node n, String xpathString) throws JspTagException {
        XPathUtil.staticInit();
        JSTLXPathVariableResolver jxvr = new JSTLXPathVariableResolver(this.pageContext);
        Node contextNode = this.adaptParamsForXalan(n, xpathString.trim(), jxvr);
        xpathString = this.modifiedXPath;
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(jstlXPathNamespaceContext);
            xpath.setXPathVariableResolver(jxvr);
            Object nl = xpath.evaluate(xpathString, contextNode, JSTLXPathConstants.OBJECT);
            return new JSTLNodeList(nl);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    public Node selectSingleNode(Node n, String xpathString) throws JspTagException {
        XPathUtil.staticInit();
        JSTLXPathVariableResolver jxvr = new JSTLXPathVariableResolver(this.pageContext);
        Node contextNode = this.adaptParamsForXalan(n, xpathString.trim(), jxvr);
        xpathString = this.modifiedXPath;
        try {
            XPath xpath = XPATH_FACTORY.newXPath();
            xpath.setNamespaceContext(jstlXPathNamespaceContext);
            xpath.setXPathVariableResolver(jxvr);
            return (Node)xpath.evaluate(xpathString, contextNode, XPathConstants.NODE);
        }
        catch (XPathExpressionException ex) {
            throw new JspTagException(ex.toString(), ex);
        }
    }

    protected Node adaptParamsForXalan(Node n, String xpath, XPathVariableResolver jxvr) {
        Node boundDocument;
        block19: {
            boundDocument = null;
            this.modifiedXPath = xpath;
            String origXPath = xpath;
            boolean whetherOrigXPath = true;
            if (n != null) {
                return n;
            }
            if (xpath.startsWith("$")) {
                String varQName = xpath.substring(xpath.indexOf("$") + 1);
                if (varQName.indexOf("/") > 0) {
                    varQName = varQName.substring(0, varQName.indexOf("/"));
                }
                String varPrefix = null;
                String varLocalName = varQName;
                if (varQName.indexOf(":") >= 0) {
                    varPrefix = varQName.substring(0, varQName.indexOf(":"));
                    varLocalName = varQName.substring(varQName.indexOf(":") + 1);
                }
                if (xpath.indexOf("/") > 0) {
                    xpath = xpath.substring(xpath.indexOf("/"));
                } else {
                    xpath = "/*";
                    whetherOrigXPath = false;
                }
                try {
                    Object varObject = ((JSTLXPathVariableResolver)jxvr).getVariableValue("", varPrefix, varLocalName);
                    if (Class.forName("org.w3c.dom.Document").isInstance(varObject)) {
                        boundDocument = (Document)varObject;
                        break block19;
                    }
                    if (Class.forName("org.apache.taglibs.standard.tag.common.xml.JSTLNodeList").isInstance(varObject)) {
                        Document newDocument = XPathUtil.getDummyDocument();
                        JSTLNodeList jstlNodeList = (JSTLNodeList)varObject;
                        if (jstlNodeList.getLength() == 1) {
                            if (Class.forName("org.w3c.dom.Node").isInstance(jstlNodeList.elementAt(0))) {
                                Node node = (Node)jstlNodeList.elementAt(0);
                                Document doc = XPathUtil.getDummyDocumentWithoutRoot();
                                Node importedNode = doc.importNode(node, true);
                                doc.appendChild(importedNode);
                                boundDocument = doc;
                                if (whetherOrigXPath) {
                                    xpath = "/*" + xpath;
                                }
                            } else {
                                Object myObject = jstlNodeList.elementAt(0);
                                xpath = myObject.toString();
                                boundDocument = newDocument;
                            }
                        } else {
                            Element dummyroot = newDocument.getDocumentElement();
                            for (int i = 0; i < jstlNodeList.getLength(); ++i) {
                                Node currNode = jstlNodeList.item(i);
                                Node importedNode = newDocument.importNode(currNode, true);
                                dummyroot.appendChild(importedNode);
                            }
                            boundDocument = newDocument;
                            xpath = "/*" + xpath;
                        }
                        break block19;
                    }
                    if (Class.forName("org.w3c.dom.Node").isInstance(varObject)) {
                        boundDocument = (Node)varObject;
                        break block19;
                    }
                    boundDocument = XPathUtil.getDummyDocument();
                    xpath = origXPath;
                }
                catch (UnresolvableException ue) {
                    ue.printStackTrace();
                }
                catch (ClassNotFoundException cnf) {}
            } else {
                boundDocument = XPathUtil.getDummyDocument();
            }
        }
        this.modifiedXPath = xpath;
        return boundDocument;
    }

    public static Node getContext(Tag t) throws JspTagException {
        ForEachTag xt = (ForEachTag)TagSupport.findAncestorWithClass(t, ForEachTag.class);
        if (xt == null) {
            return null;
        }
        return xt.getContext();
    }

    private static void p(String s) {
        System.out.println("[XPathUtil] " + s);
    }

    public static void printDetails(Node n) {
        XPathUtil.p("\n\nDetails of Node = > " + n);
        XPathUtil.p("Name:Type:Node Value = > " + n.getNodeName() + ":" + n.getNodeType() + ":" + n.getNodeValue());
        XPathUtil.p("Namespace URI : Prefix : localName = > " + n.getNamespaceURI() + ":" + n.getPrefix() + ":" + n.getLocalName());
        XPathUtil.p("\n Node has children => " + n.hasChildNodes());
        if (n.hasChildNodes()) {
            NodeList nl = n.getChildNodes();
            XPathUtil.p("Number of Children => " + nl.getLength());
            for (int i = 0; i < nl.getLength(); ++i) {
                Node childNode = nl.item(i);
                XPathUtil.printDetails(childNode);
            }
        }
    }

    static {
        jstlXPathNamespaceContext = null;
        XPATH_FACTORY_CLASS_NAME = JSTLXPathFactory.class.getName();
        try {
            XPATH_FACTORY = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", XPATH_FACTORY_CLASS_NAME, JSTLXPathFactory.class.getClassLoader());
        }
        catch (XPathFactoryConfigurationException xpce) {
            xpce.printStackTrace();
        }
        dbf = null;
        db = null;
        d = null;
    }
}

